{
Copyright (c) 2012 Yvon Massé
Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
}

unit Unit1;
{$MODE Delphi}

interface

uses
  SysUtils, Classes, Graphics, Controls, Forms, StdCtrls, Math,
  LCLIntf, Inifiles, Process, ExtCtrls, LResources, Menus;

type { TForm1 }
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Conf: TComboBox;
    ChkPa2: TCheckBox;
    ChkPb2: TCheckBox;
    ChkPc2: TCheckBox;
    ChkGa2: TCheckBox;
    ChkGb2: TCheckBox;
    ChkGc2: TCheckBox;
    ChkPa: TCheckBox;
    ChkPb: TCheckBox;
    ChkPc: TCheckBox;
    ChkGa: TCheckBox;
    ChkGb: TCheckBox;
    ChkGc: TCheckBox;
    EdPa: TEdit;
    EdPb: TEdit;
    EdPc: TEdit;
    EdGa: TEdit;
    EdGb: TEdit;
    EdGc: TEdit;
    MPrinc: TMainMenu;
    MConst: TMenuItem;
    MLang: TMenuItem;
    MPInt: TMenuItem;
    MAide: TMenuItem;
    MAProp: TMenuItem;
    UniPa: TComboBox;
    UniPb: TComboBox;
    UniPc: TComboBox;
    UniGa: TComboBox;
    UniGb: TComboBox;
    UniGc: TComboBox;
    BtCalcul: TButton;
    BtRaz: TButton;
    BtConfig: TButton;
    Info: TMemo;
    procedure ChkPa2Click(Sender: TObject);
    procedure ChkPb2Click(Sender: TObject);
    procedure ChkPc2Click(Sender: TObject);
    procedure ChkGa2Click(Sender: TObject);
    procedure ChkGb2Click(Sender: TObject);
    procedure ChkGc2Click(Sender: TObject);
    procedure ChkPaClick(Sender: TObject);
    procedure ChkPbClick(Sender: TObject);
    procedure ChkPcClick(Sender: TObject);
    procedure ChkGaClick(Sender: TObject);
    procedure ChkGbClick(Sender: TObject);
    procedure ChkGcClick(Sender: TObject);
    procedure EdPaExit(Sender: TObject);
    procedure EdPbExit(Sender: TObject);
    procedure EdPcExit(Sender: TObject);
    procedure EdGaExit(Sender: TObject);
    procedure EdGbExit(Sender: TObject);
    procedure EdGcExit(Sender: TObject);
    procedure UniPaChange(Sender: TObject);
    procedure UniPbChange(Sender: TObject);
    procedure UniPcChange(Sender: TObject);
    procedure UniGaChange(Sender: TObject);
    procedure UniGbChange(Sender: TObject);
    procedure UniGcChange(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure ConfChange(Sender: TObject);
    procedure BtCalculClick(Sender: TObject);
    procedure BtRazClick(Sender: TObject);
    procedure MConstClick(Sender: TObject);
    procedure BtConfigClick(Sender: TObject);
    procedure MAideClick(Sender: TObject);
    function FormHelp({%H-}Command: Word; {%H-}Data: PtrInt; var {%H-}CallHelp: Boolean
      ): Boolean;
    procedure MAPropClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormWindowStateChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure ChangeLng(Sender: TObject);
  private
    { Déclarations privées }
  public
    { Déclarations publiques }
  end;

  Teph = (sDc, sAh0, sLs, sRs);
  TMsgDlgType = (mtWarning, mtError, mtInformation, mtConfirmation);

const
  prc = 6;    // Nombre de chiffre des résultats
  xms = 0;    // Position des messages en x
  yms = 0;    // Position des messages en y
  agcb = 8;   // Augmentation de la largeur des ComboBox pour Mac : 60 - 52
  {$IF DEFINED(WIN32) OR DEFINED(LINUX)}
  clTriA = clWindow;
  {$ENDIF}
  {$IFDEF DARWIN}
  clTriA = Tcolor($00FFB0FF);
  {$ENDIF}
  mDic = 8;

  MTri_0 = 'Éphémérides du Soleil';
  MTri_1 = 'Hauteur du Soleil';
  MTri_2 = 'Projection gnomonique';
  MTri_3 = 'Incompatibilité des valeurs d’angle';
  MTri_4 = 'Année du résultat différente : ';
  MTri_5 = 'Format : [-]dd°mm°ss';
  MTri_6 = 'Format : [-]hh:mm:ss';
  MTri_7 = 'Format : hh:mm:ss';
  MTri_8 = 'Erreur';
  MTri_9 = 'Attention';
  MTri_10 = 'Information';
  MTri_11 = 'Confirmation';
  MTri_12 = 'OK';
  MTri_13 = 'Solution multiple';
  MTri_14 = 'Géométrie proportionnelle :'#13#10'pour obtenir une géométrie réelle'#13#10'décocher un angle et entrer un côté';
  MTri_15 = 'Valeurs de Tbol2[i], Tbol[i] et Tvar[i, 0] :';
  MTri_16 = 'Les minuscules sont les côtés du triangle sphérique'#13#10#13#10'Les majuscules correspondantes sont les angles opposés'#13#10;
  MTri_17 = 'Ce paragraphe ne se trouve plus'#13#10'dans le fichier de configuration.'#13#10'Relancer TriSph.';
  MTri_18 = 'Il faut 3 paramètres';
  MTri_19 = 'Seulement 3 paramètres';
  MTri_20 = 'Valeur de %s (en %s) :';
  MTri_21 = 'Pas de solution';
  MTri_22 = 'Options';
  MTri_23 = 'Rayon utilisateur :';
  MTri_24 = 'Erreur à la tentative d’ouvrir'#13#10'le fichier de configuration avec %s';
  MTri_25 = 'Erreur à la tentative de visualiser'#13#10'le fichier d’aide Lisezmoi%s.pdf';
  MTri_26 = 'La version du fichier de configuration est %d,'#13#10'la présente version de TriSph ne peut traiter que'#13#10'les fichiers de configuration de version 0 et 1.';
  MTri_27 = 'Fichier de configuration %s non trouvé';
  MTri_28 = 'd/m';
  MTri_29 = 'd mmm';
  MTri_30 = 'Rayon utilisateur inchangé';
  dLun = 31;
  MTri_31 = '°';
  MTri_32 = '°°';
  MTri_33 = 'rad';
  MTri_34 = 'gr';
  MTri_35 = 'm';
  MTri_36 = 'Km';
  MTri_37 = 'M';
  MTri_38 = 'Au';
  MTri_39 = 'Cu';
  MTri_40 = 'h';
  MTri_41 = 'hv';
  MTri_42 = 'yd';
  MTri_43 = 'mi';
  fLun = 43;
  MTri_44 = ''; //Réservé pour l'extension de la table des unités
  MTri_45 = '';
  MTri_46 = '';
  MTri_47 = '';
  MTri_48 = '';
  MTri_49 = '';
  MTri_50 = '°'; // Séparateur sexagésimal pour les degrés
  MTri_51 = 'Fichier de configuration :';
  MTri_52 = 'Éditeur de texte :';
  MTri_53 = 'Option de l’éditeur :';
  MTri_54 = 'Annuler';
  MTri_55 = 'Voulez-vous utiliser l’éditeur %s'#13#10'à la place de %s ?';
  MTri_56 = 'Voulez-vous modifier l’option %s'#13#10'de l’éditeur de texte par %s ?';
  MTri_57 = 'TriSph version du 17 avril 2017';

  mMTri = 57;

var
  Form1: TForm1;
  LiC: Array[0..19] of TCheckBox;     // Table des objets case à cocher
  Etiq: Array[0..5] of String;        // Table des mnémoniques
  Tbol: Array[0..19] of Boolean;      // Table des valeurs d'entrée valides
  LiC2: Array[0..5] of TCheckBox;     // Table des objets case à cocher secondaires
  Tbol2: Array[0..5] of Boolean;      // Table des valeurs d'entrée valides secondaires
  LiE: Array[0..19] of TEdit;         // Table des objets champ de saisie
  LiB: Array[0..19] of TComboBox;     // Table des objets boîte de sélection
  LunB: Array[0..2] of String;        // Listes d'unité des boîtes de sélection de la fenêtre principale
  Unt: Array[0..19] of Integer;       // Table des unités
  Tvar: Array[0..19, 0..1] of Real;   // Table des valeurs angulaires en °
  Comp: Array[0..5] of Boolean;       // Table des complémentations
  Srot: Array[3..5] of Integer;       // Table des signes
  Grot: Integer;                      // Contexte de travail
  Trip: Boolean = False;              // Triangle plan
  frm: Boolean = False;               // A l'initialisation les autres Form ne sont pas créées
  lngNT: Boolean = False;             // Pour gérer le message de fichier .lng non trouvé
  vcf: Integer = 0;                   // Version du fichier de configuration
  Mrv: Array[0..4] of Boolean;        // Mémorisation des renvois vers les modules de calcul spécifique
  fm2x, fm3x, fm4x: Boolean;          // Pour gérer les fenêtres lors de la réduction de l'application
  Tri1: Longint;
//  Tri2: Longint;
  men: Boolean = True;                // Pour gerer l'accès à la fenêtre modale
  aged: Integer;                      // Pour adapter les fenêtre quand l'OS n'est pas Windows
  App: String;                        // Application pour éditer le fichier de configuration
  Opt: String;                        // Option pour l'application
  Fcf: String;                        // Fichier de configuration
  rayu: Real;                         // Rayon utilisateur
  Elng: String;                       // Extention pour les fichiers de langue différente
  Dic: Array[0..mDic - 1] of String = ('MTri', 'OTri', 'MEph', 'OEph', 'MHaut', 'OHaut', 'MPro', 'OPro');
  MTri: Array[0..mMTri] of String =
    (MTri_0, MTri_1, MTri_2, MTri_3, MTri_4, MTri_5, MTri_6, MTri_7, MTri_8, MTri_9,
    MTri_10, MTri_11, MTri_12, MTri_13, MTri_14, MTri_15, MTri_16, MTri_17, MTri_18, MTri_19,
    MTri_20, MTri_21, MTri_22, MTri_23, MTri_24, MTri_25, MTri_26, MTri_27, MTri_28, MTri_29,
    MTri_30, MTri_31, MTri_32, MTri_33, MTri_34, MTri_35, MTri_36, MTri_37, MTri_38, MTri_39,
    MTri_40, MTri_41, MTri_42, MTri_43, MTri_44, MTri_45, MTri_46, MTri_47, MTri_48, MTri_49,
    MTri_50, MTri_51, MTri_52, MTri_53, MTri_54, MTri_55, MTri_56, MTri_57//, MTri_58, MTri_59,
    );

  function nunt(st: String): Integer;
  function lecs(ch: String; i: Integer; var vl: Real): Boolean;
  function mods(i: Integer): Boolean;
  function modr(i: Integer): Real;
  function chrt(rst: Real; i, pr: Integer): String;
  function chnt(i: Integer): String;
  Procedure ChkClick(i: Integer);
  Procedure EdExit(i: Integer);
  procedure afrt(i: Integer);
  procedure UniChange(i: Integer);
  procedure quits();
  procedure clng(nf: Integer);
  function ephe(jr, hr: Real; ts: Teph): Real;
  Procedure MessDlgPos(msg: String; typ: TMsgDlgType; xpos, ypos: Integer);
  function SelBoxPos(cp, tf: String; tc: Array of String; nb, xpos, ypos: Integer): Integer;
  function DimT(txt: String; Can: TCanvas): TPoint;
  function MulDiv(nb, num, den: Integer): Integer;

implementation

uses Unit2, Unit3, Unit4;

{$R *.lfm} { TForm1 }

function indx(tst: TStrings; st: String): Integer;
// Retourne l'index de tst contenant la chaîne st, si non trouvée retourne -1
begin
  for Result := 0 to tst.Count - 1 do
    if tst[Result] = st then Exit;
  Result := -1;
end;

function nunt(st: String): Integer;
// Retourne le numéro de l'unité de la chaîne st, si non valide retourne -1
begin
  for Result := 0 to fLun - dLun do
    if MTri[Result + dLun] = st then Exit;
  Result := -1;
end;

function cadi(mot: String; i: Integer): String;
// Traite les mnémoniques contenant le caractère '~'
Const
 dp = 180;        // Position des Form 2 et 3 par rapport à Form1
var
 ch: String;
 ps: Integer;
 fm: Integer;
begin
  fm := 0;
  ps := Pos('~', mot);
  if ps = 0 then
    Result := mot
  else
  begin
    ch := UpperCase(Copy(mot, ps + 1, Length(mot) - ps));
    if (ch = 'AH') and not Mrv[0] then
    begin
      Form2.ChkAh.Hide; Form2.EdAh.Hide; Form2.UniAh.Hide;
      Ah := i;
      LiC2[i].Visible := True;
      LiC2[i].Hint := MTri[0];
      Mrv[0] := True;
      fm := 2;
    end;
    if (ch = 'DC') and not Mrv[1] then
    begin
      Form2.ChkDc.Hide; Form2.EdDc.Hide; Form2.UniDc.Hide;
      dc := i;
      LiC2[i].Visible := True;
      LiC2[i].Hint := MTri[0];
      Mrv[1] := True;
      fm := 2;
    end;
    if (ch = 'HR') and not Mrv[2] then
    begin
      hr := i;
      LiC2[i].Visible := True;
      LiC2[i].Hint := MTri[1];
      Mrv[2] := True;
      fm := 3;
    end;
    if (ch = 'ST') and not Mrv[3] then
    begin
      Form4.ChkSt.Hide; Form4.EdSt.Hide; Form4.UniSt.Hide;
      if Az < 6 then Form4.Label3.Hide;
      st := i;
      LiC2[i].Visible := True;
      LiC2[i].Hint := MTri[2];
      Mrv[3] := True;
      fm := 4;
    end;
    if (ch = 'AZ') and not Mrv[4] then
    begin
      Form4.ChkAz.Hide; Form4.EdAz.Hide; Form4.UniAz.Hide;
      if st < 6 then Form4.Label3.Hide;
      Az := i;
      LiC2[i].Visible := True;
      LiC2[i].Hint := MTri[2];
      Mrv[4] := True;
      fm := 4;
    end;
    case fm of
      2:
        if not Form2.Visible then
        begin
          Form2.Left := Form1.Left + Form1.Width + 16;
          Form2.Top := Form1.Top + dp;
          Form2.Show;
        end;
      3:
        if not Form3.Visible then
        begin
          Form3.Left := Form1.Left + Form1.Width + 16;
          Form3.Top := Form1.Top - Form3.Height + dp - 38;
          Form3.Show;
          // Initialisation de la collimation et de la hauteur de l'oeil
          LiC[13].Checked := True;
          LiE[13].Text := '0'; LiE[13].Modified := True;
          EdExit(13);
          LiC[14].Checked := True;
          LiE[14].Text := '0'; LiE[14].Modified := True;
          EdExit(14);
//          Form3.ChkHoTh.Checked := True;
        end;
      4:
        if not Form4.Visible then
        begin
          Form4.Left := Form1.Left + Form1.Width - Form4.Width - 0;
          Form4.Top := Form1.Top + Form1.Height + 38;
          Form4.Show;
        end;
    end;
    Form1.Setfocus;
    Result := Copy(mot, 1 , ps - 1);
  end;
end;

function vals(ch, sp: String; var vl: Real): Boolean;
// Evalue la chaîne ch pouvant contenir des séparateurs sp pour le système sexagésimal
var
  i, b: Integer;
begin
  b := 1; ch := TrimLeft(ch);
  if (ch <> '') and (ch[1] = '-') then
  begin
    b := -1;
    Delete(ch, 1, 1);
  end;
  vl := 0; Result := False;
  repeat
    i := Pos(sp, ch);                    // Recherche de sp dans ch
    if i = 0 then i := Length(ch) + 1;
    try                                  // Evaluation du chiffre avant sp
      vl := vl + StrToFloat(Copy(ch, 1, i - 1))/b;
      b := 60*b;
      Delete(ch, 1, i + Length(sp) - 1);              // On supprime la partie évaluée
    except
      Result := True;
    end;
  until Result or (ch = '');
end;

function lecs(ch: String; i: Integer; var vl: Real): Boolean;
// Lecture de la saisie d'indice i
begin
  Result := False;        // Pour les cas (fLun - dLun + 1) et else
  case Unt[i] of
    0, 1: // °, °°
      Result := vals(ch, MTri[50], vl);
    9: // h
    begin
      Result := vals(ch, ':', vl);
      vl := vl*15;
    end;
    10: // hv
    begin
      Result := vals(ch, ':', vl);
      vl := vl*15 - 180;
      if (vl < 0) and (Abs(Srot[i]) = 2) then vl := vl + 360;
    end;
    fLun - dLun + 1: // j
    try
      vl := StrToDate(ch);
      vl := StrToDate(FormatDateTime(MTri[28], vl) + '/' + Form2.CmbAn.Text);
    except
      Result := True;
    end;
    else
    begin
      try
        vl := StrToFloat(ch);
      except
        Result := True;
        Exit;
      end;
      case Unt[i] of
        2: // rad
          vl := RadToDeg(vl);
        3: // gr
          vl := vl*0.9;
        4: // m
          vl := vl*9e-6;
        5: // Km
          vl := vl*0.009;
        11: // yd
          vl := vl*8.2296e-6;
        12: // mi
          vl := vl*0.014484096;
        6: // M
          vl := vl/60;
        7: // Au
          vl := RadToDeg(vl/rayu);
        8: // Cu
        begin
          vl := vl/2/rayu;
          if (vl > 1) or (vl < -1) then
            Result := True
          else
            vl := RadToDeg(2*ArcSin(vl));
        end;
      end;
    end;
  end;
end;

function mods(i: Integer): Boolean;
const
 colm = 1;     // valeur absolue de la collimation maxi
 depm = 1.51;  // depression maxi en fonction des paramètres atmosphériques maxi
var
  bl: Boolean;
begin
  case i of
    0, 1, 2: begin
      if Comp[i] then Tvar[i, 0] := 90 - Tvar[i, 0];
      Result := (Tvar[i, 0] <= 0) or (Tvar[i, 0] >= 180) and not Trip;
    end;
    3, 4, 5: begin
      if Grot <> 0 then
      begin
        // Contexte de travail : application pratique
        if Tbol[3 + (i - 2) mod 3] or Tbol[3 + (i - 1) mod 3] then
        begin
        // Un autre angle a déjà été saisi, vérification de la compatibilité
          case Grot*Srot[i] of
            1, -1: begin
              Tvar[i, 0] := Grot*Srot[i]*Tvar[i, 0];
              bl := Tvar[i, 0] < 0;
              end;
            2, -2: begin
              if Grot*Srot[i] < 0 then Tvar[i, 0] := 360 - Tvar[i, 0];
              bl := Tvar[i, 0] > 180;
              end;
          end;
          if bl then
            MessDlgPos(MTri[3], mtError, Form1.Left + xms, Form1.Top + yms);
        end
        else
        begin
        // Premier angle saisi, il détermine la valeur de Grot
          case Srot[i] of
            1, -1:
            if Tvar[i, 0] < 0 then
            begin
              Tvar[i, 0] := -Tvar[i, 0];
              Grot := -Srot[i];
            end
            else
              Grot := Srot[i];
          2, -2:
            if Tvar[i, 0] > 180 then
            begin
              Tvar[i, 0] := 360 - Tvar[i, 0];
              Grot := -Srot[i] div 2;
            end
            else
              Grot := Srot[i] div 2;
          end;
        end;
      end;
      if Comp[i] then Tvar[i, 0] := 180 - Tvar[i, 0];
      Result := (Tvar[i, 0] <= 0) or (Tvar[i, 0] >= 180);
    end;
    6: Result := False;
    7: Result := (Tvar[i, 0] < 0) or (Tvar[i, 0] > 360);
    8: Result := (Abs(Tvar[i, 0]) > 180) or (Round(10*Tvar[i, 0]) mod 150 <> 0);
    9, 10: Result := Abs(Tvar[i, 0]) > 180;
    11: Result := Abs(Tvar[i, 0]) > 23.5;
    12: Result := (Tvar[i, 0] < -depm - colm) or (Tvar[i, 0] > 2*(90 + depm) + colm);
    13: Result := (Tvar[i, 0] < -colm) or (Tvar[i, 0] > colm);
    14: Result := (Tvar[i, 0] < 0) or (Tvar[i, 0] > altm);
    15: Result := Tvar[i, 0] <= 0;
    16: Result := Tvar[i, 0] = 0;
    17: Result := False;
    18: Result := (Tvar[i, 0] <= 0) or (Tvar[i, 0] >= 90);
    19: Result := (Tvar[i, 0] = 0) or (Abs(Tvar[i, 0]) >= 180)
  end;
end;

function modr(i: Integer): Real;
// Complémentation et modification de la valeur de l'angle en fonction de Grot
begin
    Result := Tvar[i, 0];
  if Comp[i] then                    // Complémentation ?
    if i < 3 then
      Result := 90 - Result
    else
      Result := 180 - Result;
  if (i >= 3) and (Grot <> 0) then   // Valeur de l'angle en fonction de Grot
    case Grot*Srot[i] of
      -1: Result := -Result;
      -2: Result := 360 - Result;
    end;
end;

function FlToSt(rst: Float; pr: Integer): String;
var
  st: String;
begin
  Result := FloatToStrF(rst, ffGeneral, pr, 1);
  st := FloatToStrF(rst, ffExponent, pr, 1);
  if Length(Result) >= Length(st) then
    Result := st
end;

function chrt(rst: Real; i, pr: Integer): String;
// Chaine du résultat d'indice i
begin
  case Unt[i] of
    0: // °
      Result := FlToSt(rst, pr);
    1: // °°
    begin
      Result := ''; if rst < 0 then Result := '-';
      rst := Abs(rst);
      if SameValue(rst, Round(rst), 0.005/3600) then rst := Round(rst); // Pour ne pas avoir 9°60°0.00, par exemple
      Result := Result + IntToStr(Floor(rst)) + MTri[50];
      rst := 60*Frac(rst);
      if SameValue(rst, Round(rst), 0.005/60) then rst := Round(rst); // Pour ne pas avoir 20°11°60.00, par exemple
      Result := Result + IntToStr(Floor(rst)) + MTri[50];
      rst := 60*Frac(rst);
      Result := Result + FloatToStrF(rst, ffFixed, pr, 2);
    end;
    2: // rad
      Result := FlToSt(DegToRad(rst), pr);
    3: // gr
      Result := FlToSt(rst/0.9, pr);
    4: // m
      Result := FlToSt(rst/9e-6, pr);
    5: // Km
      Result := FlToSt(rst/0.009, pr);
    11: // yd
      Result := FlToSt(rst/8.2296e-6, pr);
    12: // mi
      Result := FlToSt(rst/0.014484096, pr);
    6: // M
      Result := FlToSt(rst*60, pr);
    7: // Au
      Result := FlToSt(DegToRad(rst)*rayu, pr);
    8: // Cu
      Result := FlToSt(2*Sin(DegToRad(rst/2))*rayu, pr);
    9: // h
    begin
      if i = 8 then
        Result := FormatDateTime('hh:nn', Abs(rst/360))
      else
        Result := TimeToStr(Abs(rst/360));
      if rst < 0 then Result := '-' + Result;
    end;
    10: // hv
      Result := TimeToStr(rst/360 + 0.5);
    fLun - dLun + 1: // j
    case pr of
      0: Result := FormatDateTime(MTri[29], rst);
      else Result := FormatDateTime(MTri[28], rst);
    end;
  end;
end;

procedure afrt(i: Integer);
// Affichage du résultat d'indice i
// Procédure utilisée uniquement par les modules de TriSph
begin
  LiE[i].Text := chrt(Tvar[i, 0], i, prc);
  LiE[i].Modified := False;
  case i of
    0, 1, 2, 3, 4, 5: begin
      if mods(i) then LiE[i].Text := '';
      if LiC[i].Checked then Tbol[i] := LiE[i].Text <> '';
      LiE[i].Modified := False;
    end;
    6: begin
      if FormatDateTime('yyyy', Tvar[i, 0]) <> Form2.CmbAn.Text then
        MessDlgPos(MTri[4] + FormatDateTime('yyyy', Tvar[i, 0]),
                       mtInformation, Form2.Left + xms, Form2.Top + yms);
      Form2.AEdJo.Caption := FormatDateTime(MTri[29], Tvar[i, 0]);
    end;
    7: Form2.AEdHo.Caption := TimeToStr(Tvar[i, 0]/360);
  end;
end;

function chnt(i: Integer): String;
// Retourne le texte de l'info-bulle en fonction de Unt[i]
begin
  case Unt[i] of
    0, 1: // °, °°
      Result := MTri[5];
    9: // h
      Result := MTri[6];
    10: // hv
      Result := MTri[7];
    else Result := '';
  end;
end;

Procedure Chk2Click(i: Integer);
begin
  if (i = Ah) and not Form2.Visible then Form2.Show;
  if (i = dc) and not Form2.Visible then Form2.Show;
  if (i = hr) and not Form3.Visible then Form3.Show;
  if (i = st) and not Form4.Visible then Form4.Show;
  if (i = Az) and not Form4.Visible then Form4.Show;
  Form1.Setfocus;
end;

Procedure rsym(i: Integer);
// Remet la ligne de saisie en état si affichage d'un résultat symbolique
begin
  if (i < 6) and (Tvar[i, 0] < -45) then
  begin
    LiB[i].Enabled := True;
    LiB[i].Text := MTri[Unt[i] + dLun];
    LiE[i].Text := '';
    LiE[i].Modified := False;
  end;
end;

Procedure ChkClick(i: Integer);
// Routine après clic sur boîte à cocher d'indice i
var
  ca: Integer;
begin
  ca := 0; if LiC[i].Checked then ca := 1;
  if (i < 6) and LiC2[i].Checked then ca := ca + 2;
  case ca of
    0: begin
      LiE[i].TabStop := False;
      LiE[i].ReadOnly := True;
      LiE[i].Color := clForm;
      Tbol[i] := False;
      if i < 6 then Tbol2[i] := False;
    end;
    1: begin
      LiE[i].TabStop := True;
      LiE[i].ReadOnly := False;
      LiE[i].Color := clTriA;
      rsym(i);
      Tbol[i] := LiE[i].Text <> '';
      if i < 6 then Tbol2[i] := False;
    end;
    2: begin
      LiE[i].TabStop := True;
      LiE[i].ReadOnly := False;
      LiE[i].Color := Tcolor(Tri1);
      rsym(i);
      Tbol[i] := False;
      Tbol2[i] := LiE[i].Text <> '';
    end;
    3: begin
      LiE[i].Color := clTriA;
      rsym(i);
      Tbol[i] := LiE[i].Text <> '';
      Tbol2[i] := Tbol[i];
    end;
  end;
end;

Procedure EdExit(i: Integer);
// Routine de sortie du champ de saisie d'indice i
begin
  case i of
    6: if LiE[i].Text = '*' then
       begin
         // Pour prendre aussi en compte l'année en cours, décommenter la ligne suivante
         // Form2.CmbAn.Text := FormatDateTime('yyyy', Date);
         LiE[i].Text := FormatDateTime(MTri[28], Date);
         LiE[i].Modified := True;
       end;
    7: if LiE[i].Text = '*' then
       begin
         LiE[i].Text := TimeToStr(Time);
         LiE[i].Modified := True;
       end;
  end;
  if LiE[i].Modified then
  begin
    if lecs(LiE[i].Text, i, Tvar[i, 0]) then
      LiE[i].Text := ''
    else
      if mods(i) then LiE[i].Text := '';
    if LiC[i].Checked then Tbol[i] := LiE[i].Text <> '';
    if (i < 6) and LiC2[i].Checked then Tbol2[i] := LiE[i].Text <> '';
    LiE[i].Modified := False;
  end;
  case i of
    6: if Tbol[i] then
         Form2.AEdJo.Caption := FormatDateTime(MTri[29], Tvar[i, 0])
       else
         Form2.AEdJo.Caption := '';
    7: if Tbol[i] then
         Form2.AEdHo.Caption := TimeToStr(Tvar[i, 0]/360)
       else
         Form2.AEdHo.Caption := '';
  end;
end;

procedure UniChange(i: Integer);
// Routine de changement d'unité d'indice i
begin
  {$IF DEFINED(LINUX) OR DEFINED(DARWIN)}
  if frm then quits();
  {$ENDIF}
  Unt[i] := nunt(LiB[i].Text);
  if (i <> 12) and (i <> 18) then LiE[i].Hint := chnt(i); // Pas de changement pour H. inst. et Site
  if LiE[i].Text <> '' then
    if i < 6 then
    begin
      LiE[i].Text := chrt(modr(i), i, prc);
      LiE[i].Modified := False
    end
    else
      afrt(i);
end;

procedure quits();
// Force la sortie des champs de saisie
var
  i: Integer;
begin
  for i := 0 to 5 do
    if Form1.ActiveControl = TWinControl(LiE[i]) then EdExit(i);
  if Form2.ActiveControl = Form2.CmbAn then Form2.CmbAnExit(nil);
  for i := 6 to 11 do
    if Form2.ActiveControl = TWinControl(LiE[i]) then EdExit(i);
  for i := 12 to 14 do
    if Form3.ActiveControl = TWinControl(LiE[i]) then EdExit(i);
  for i := 15 to 19 do
    if Form4.ActiveControl = TWinControl(LiE[i]) then EdExit(i);
end;

function MulDiv(nb, num, den: Integer): Integer;
begin
  Result := Round(nb*num/den)
end;

function DimT(txt: String; Can: TCanvas): TPoint;
var
  i, nl: Integer;
begin
  nl := 0;
  Result.X := 0;
  Result.Y := Can.TextHeight(txt);
  repeat
    i := Pos(#13#10, txt);                           // Recherche de CRLF dans txt
    if i = 0 then i := Length(txt) + 1;
    Result.X := Max(Result.X,
                Can.TextWidth(Copy(txt, 1, i - 1))); // Evaluation de la taille avant CRLF
    Delete(txt, 1, i + 1);                           // On supprime la partie évaluée
    Inc(nl);                                         // Une ligne supplémentaire
  until txt = '';
  Result.Y := nl*Result.Y;
end;

function ephe(jr, hr: Real; ts: Teph): Real;
const
  kl = 0.017202792; // Vitesse angulaire de la longitude moyenne en radian/jour
  jl = 43912.041;  // Date centrale de la période d’utilisation où la longitude moyenne est nulle
  km = 0.01720197;   // Vitesse angulaire de l’anomalie moyenne en radian/jour
  jm = 43834.200;   // Date centrale de la période d’utilisation où l’anomalie est nulle
var
  ju, m, l, s: Real;
  e, ob: Real;
  o, dl, mv, mm, mj, pl: Real;
  x, y: Real;
begin
  ju := jr + hr/360;
  e := 0.0167 - 1.15e-9*(ju - 44437);// Excentricité de l'orbite terrestre
  m := km*(ju - jm);                 // Anomalie moyenne
  l := kl*(ju - jl);                 // Longitude moyenne
  l := ArcTan2(Sin(l), Cos(l));      // Dans l'interval ]-Pi, Pi]
  s := l + 2*e*Sin(m) + 1.25*Sqr(e)*Sin(2*m) + 1.08*Sqr(e)*e*Sin(3*m); // Longitude vraie
  o := -9.242e-4*(ju - 45686);  // Longitude du noeud ascendant de la lune
  ob := 0.40905 + 4.47e-5*Cos(o) - 6.22e-9*(ju - 43378);// Obliquité corrigée de la nutation et variation séculaire
  dl := -8.36e-5*sin(o) - 0.62e-5*sin(2*l);             // Nutation en longitude
  mv := 0.027962 *(ju - 43910);      // Anomalie moyenne de Vénus
  mm := 0.009146 *(ju - 43359);      // Anomalie moyenne de Mars
  mj := 0.001450 *(ju - 44954);      // Anomalie moyenne de Jupiter
  pl := 0.2127687*(ju - 43884.7);    // Phase de la lune
  s := s + dl + 3.12e-5*Sin(pl);     // Corrections lunaire et de nutation
  s := s + 2.35e-5*Cos(5.22 +   mv -   m);        // Correction de Venus
  s := s + 2.68e-5*Cos(2.59 + 2*mv - 2*m);
  s := s + 1.21e-5*Cos(5.51 + 2*mv - 3*m);
  s := s + 0.76e-5*Cos(6.03 + 3*mv - 4*m);
  s := s + 0.50e-5*Cos(5.55 + 3*mv - 5*m);
  s := s - 0.90e-5*Sin(3.90 - 8*mv +13*m);        // (longue période)
  s := s + 0.99e-5*Cos(6.00 - 2*mm + 2*m);        // Correction de Mars
  s := s + 0.86e-5*Cos(3.50 - 2*mm +   m);
  s := s + 3.49e-5*Cos(3.13 -   mj +   m);        // Correction de Jupiter
  s := s + 1.26e-5*Cos(4.59 -   mj);
  s := s + 1.32e-5*Cos(1.52 - 2*mj + 2*m);
  s := s + 0.78e-5*Cos(1.91 - 2*mj +   m);
  s := s + 3.10e-5*Sin(0.63 + 3*mj - 8*mm + 4*m); // Longue période
  case ts of
    sLs: Result := RadToDeg(ArcTan2(Sin(s), Cos(s)));  // Longitude écliptique
    sDc: Result := RadToDeg(ArcSin(Sin(ob)*Sin(s)));   // Déclinaison
    sAh0: begin                                        // Equation du temps
      x := Cos(s); y := Cos(ob)*Sin(s);
      l := l + dl*Cos(ob);
      Result := RadToDeg(ArcTan2(Sin(l)*x - Cos(l)*y, Cos(l)*x + Sin(l)*y));
    end;
    sRs: Result := 16*(1 + e*Cos(m))/60;
  end;
end;

Procedure MessDlgPos(msg: String; typ: TMsgDlgType; xpos, ypos: Integer);
// Boîte de dialogue avec icône
var
  MBox: TForm;
  Dim: Tpoint;
  esph, espv, finh, finv: Integer;
begin
  MBox := TForm.Create(Application);
  with Mbox do
    try
      BorderStyle := bsDialog;
      case typ of
        mtError: Caption := MTri[8];
        mtWarning: Caption := MTri[9];
        mtInformation: Caption := MTri[10];
        mtConfirmation: Caption := MTri[11];
      end;
      Left := xpos;
      Top := ypos;
      Dim := DimT('X', Canvas);
      esph := MulDiv(2, Dim.X, 2);
      espv := MulDiv(1, Dim.Y, 2);
      with TImage.Create(MBox) do
      begin
        Parent := MBox;
        case typ of
          mtError: Picture.LoadFromLazarusResource('error');
          mtWarning: Picture.LoadFromLazarusResource('warning');
          mtInformation: Picture.LoadFromLazarusResource('information');
          mtConfirmation: Picture.LoadFromLazarusResource('confirmation');
        end;
        Width := Picture.Width;
        Height := Picture.Height;
        Left := esph; Top := espv;
        finh := Left + Width;
        finv := Top + Height;
      end;
      with TLabel.Create(MBox) do
      begin
        Parent := MBox;
        Caption := msg;
        Left := finh + esph; Top := espv;
        Dim := DimT(msg, Canvas);
        finh := Left + Dim.X;
        finv := Max(finv, Top + Dim.Y);
      end;
      with TButton.Create(MBox) do
      begin
        Parent := MBox;
        Caption := MTri[12];
        Left := (finh + esph - Width) div 2 ;
        Top := finv + espv;
        finv := Top + Height;
        ModalResult := mrOK;
      end;
      ClientWidth := finh + esph;
      ClientHeight := finv + espv;
      if ShowModal = mrOK then;
    finally
      MBox.Free;
    end;
end;

function SelBoxPos(cp, tf: String; tc: Array of String; nb, xpos, ypos: Integer): Integer;
// tf : texte explicatif du choix à effectuer
// tc : tableau des textes à placer dans les boutons
// nb : nombre de bouton à selectionner
// xpos, ypos : position de la fenêtre
// la valeur retournée correspond au numéro du choix
const
  cod = 16;
var
  Form: TForm;
  Dim: Tpoint;
  i, esph, espv, finh, finv, fbt: Integer;
begin
  Form := TForm.Create(Application);
  with Form do
    try
      BorderStyle := bsDialog;
      Caption := cp;
      Left := xpos;
      Top := ypos;
      Dim := DimT('X', Canvas);
      esph := MulDiv(2, Dim.X, 2);
      espv := MulDiv(1, Dim.Y, 2);
      with TImage.Create(Form) do
      begin
        Parent := Form;
        Picture.LoadFromLazarusResource('confirmation');
        Width := Picture.Width;
        Height := Picture.Height;
        Left := esph; Top := espv;
        finh := Left + Width;
        finv := Top + Height;
      end;
      with TLabel.Create(Form) do
      begin
        Parent := Form;
        Caption := tf;
        Left := finh + esph; Top := espv;
        Dim := DimT(tf, Canvas);
        finh := Left + Dim.X;
        finv := Max(finv, Top + Dim.Y);
      end;
      fbt := 0;
      for i := 0 to nb - 1 do
        with TButton.Create(Form) do
        begin
          Parent := Form;
          Width := LiE[0].Width;
          Caption := tc[i];
          if i = 0 then
          begin
            Default := True;
            Cancel := True;
            finv := finv + espv + Height;
          end;
          Left := fbt + esph;
          Top := finv - Height;
          fbt := Left + Width;
          ModalResult := i + cod;
        end;
      finh := Max(finh, fbt);
      ClientWidth := finh + esph;
      ClientHeight := finv + espv;
      Result := ShowModal;
      if Result = 2 then Result := cod;
      Result := Result - cod + 1;
    finally
      Form.Free;
    end;
end;

function dgui(chg: String): String;
// Extrait la sous-chaine de chg située entre 2 guillemets simples
var
  i: Integer;
  bl: Boolean;
begin
  Result := '';
  i := Pos('''', chg);
  if i <> 0 then
  begin                    // Le premier guillemet a été trouvé
    Delete(chg, 1, i);
    repeat
      bl := False;
      i := Pos('''', chg);
      if i <> 0 then
      begin                // Un guillemet suivant aussi
        if (Length(chg) > i) and (chg[i + 1] = '''') then
        begin              // Le guillemet est doublé
          Inc(i);
          bl := True;
        end;
        Result := Result + Copy(chg, 1, i - 1);
        Delete(chg, 1, i);
      end
      else
        Result := Result + chg;
    until not bl;
  end;
end;

procedure clst(Lst: TStrings; st: String; vun: Boolean);
// Chargement dans la liste Lst des éléments de la chaîne st séparés par |
// Si vun = True, vérification que les éléments soient bien des noms d'unité valides
var
  i: Integer;
  s: String;
begin
  Lst.Clear;
  repeat
    i := Pos('|', st);
    if i = 0 then i := Length(st) + 1;
    s := Copy(st, 1, i - 1);
    if vun and (nunt(s) < 0) then else Lst.Add(s);
    Delete(st, 1, i);
  until st = '';
end;

procedure cmen(MIt: TMenuItem; st: string);
// Chargement dans le menu MIt des éléments de la chaîne st séparés par |
var
  i, j: integer;
  s: string;
begin
  j := 0;
  repeat
    i := Pos('|', st);
    if i = 0 then
      i := Length(st) + 1;
    s := Copy(st, 1, i - 1);
    Delete(st, 1, i);
    i := Pos('_', s);
    if i = 0 then
      MIt[j].Caption := s
    else
    begin
      MIt[j].Caption := Copy(s, 1, i - 1);
      MIt[j].ShortCut := ShortCut(word(s[Length(s)]), [ssCtrl]);
    end;
    Inc(j);
  until st = '';
end;

procedure clng(nf: Integer);
// Modifie les chaînes des messages et des objets
// nf = 0 : messages de Unit1
// nf = 1 : objets de Form1
// nf = 2 : messages et objets de Unit2 / Form2
// nf = 3 : messages et objets de Unit3 / Form3
// nf = 4 : messages et objets de Unit4 / Form4
var
  fic: TextFile;
  i, j, k: Integer;
  bl: Boolean;
  lin, st: String;
begin
  {$IFDEF WIN32}
  st := GetCurrentDir + Format('\Langage%s.lng', [Elng]);
  {$ENDIF}
  {$IFDEF LINUX}
  st := ExtractFilePath(ParamStr(0)) + Format('Langage%s.lng', [Elng]);
  {$ENDIF}
  {$IFDEF DARWIN}
  st := ExtractFilePath(ParamStr(0)) + Format('../Resources/Langage%s.lng', [Elng]);
  {$ENDIF}
  if FileExists(st) then
  begin
    AssignFile(fic, st);
    Reset(fic);
    while not Eof(fic) do
    begin
      Readln(fic, lin);
      i := Pos('_', lin);
      if i <> 0 then
      begin
        st := Uppercase(Trim(Copy(lin, 1, i - 1)));
        for j := 0 to mDic do
          if (j < mDic) and (st = Uppercase(Dic[j])) then Break;
        case j of             // Evalue si la chaîne est concernée
          0: bl := nf = 0;
          1: bl := nf = 1;
          2, 3: bl := nf = 2;
          4, 5: bl := nf = 3;
          6, 7: bl := nf = 4;
          else bl := False;
        end;
        if bl then
        begin
          Delete(lin, 1, i);
          i := Pos('=', lin);
          if i <> 0 then
          begin
            try
              k := StrToInt(Trim(Copy(lin, 1, i - 1)));
            except
              k := -1;
            end;
            Delete(lin, 1, i);
            lin := dgui(lin);
            st := '';
            repeat                // Remplacement de \ par #13#10
              i := Pos('\', lin);
              if i = 0 then
                st := st + lin
              else
              begin
                st := st + Copy(lin, 1, i - 1) + #13#10;
                Delete(lin, 1, i);
              end;
            until i = 0;
            case j of
            0: if k in [0..mMTri] then MTri[k] := st;
            1: case k of
              0: Form1.Label1.Caption := st;
              1: Form1.Label2.Caption := st;
              2: Form1.Label3.Caption := st;
              3: clst(Form1.Conf.Items, st, False);
              4: clst(Form1.UniPa.Items, st, True);
              5: clst(Form1.UniPb.Items, st, True);
              6: clst(Form1.UniPc.Items, st, True);
              7: clst(Form1.UniGa.Items, st, True);
              8: clst(Form1.UniGb.Items, st, True);
              9: clst(Form1.UniGc.Items, st, True);
              10: Form1.BtCalcul.Caption := st;
              11: Form1.BtRaz.Caption := st;
//              12: Form1.BtConst.Caption := st;
              12: cmen(Form1.MPrinc.Items, st);
              13: Form1.BtConfig.Caption := st;
//              14: Form1.BtLisez.Caption := st;
              14: cmen(Form1.MPrinc.Items[2], st);
              end;
            2: if k in [0..mMEph] then MEph[k] := st;
            3: case k of
              0: Form2.Caption := st;
              1: Form2.Label1.Caption := st;
              2: Form2.Label2.Caption := st;
              3: Form2.Label3.Caption := st;
              4: Form2.Label4.Caption := st;
              5: Form2.ChkJo.Caption := st;
              6: Form2.ChkHo.Caption := st;
              7: Form2.ChkFo.Caption := st;
              8: Form2.ChkLg.Caption := st;
              9: clst(Form2.UniLg.Items, st, True);
              10: Form2.ChkAh.Caption := st;
              11: clst(Form2.UniAh.Items, st, True);
              12: Form2.ChkDc.Caption := st;
              13: clst(Form2.UniDc.Items, st, True);
              14: Form2.BtCalcul.Caption := st;
              15: Form2.BtRaz.Caption := st;
              16: Form2.EdJo.Hint := st;
              17: Form2.EdHo.Hint := st;
              18: Form2.EdFo.Hint := st;
              end;
            4: if k in [0..mMHaut] then MHaut[k] := st;
            5: case k of
              0: Form3.Caption := st;
              1: Form3.Label1.Caption := st;
              2: Form3.Label2.Caption := st;
              3: Form3.Label3.Caption := st;
              4: Form3.Label4.Caption := st;
              5: clst(Form3.CmbSo.Items, st, False);
              6: Form3.ChkHi.Caption := st;
              7: clst(Form3.UniHi.Items, st, True);
              8: Form3.ChkCo.Caption := st;
              9: clst(Form3.UniCo.Items, st, True);
              10: begin
                Form3.ChkHe.Caption := st;
                Form3.Label6.Caption := st;
              end;
              11: Form3.BtCalcul.Caption := st;
              12: Form3.BtRaz.Caption := st;
              13: Form3.ChkHoTh.Caption := st;
              14: Form3.ChkDbl.Caption := st;
              15: Form3.ChkPrlx.Caption := st;
              16: Form3.BtPar.Caption := st;
              end;
            6: if k in [0..mMPro] then MPro[k] := st;
            7: case k of
              0: Form4.Caption := st;
              1: Form4.Label1.Caption := st;
              2: Form4.Label2.Caption := st;
              3: Form4.Label3.Caption := st;
              4: Form4.ChkG.Caption := st;
              5: Form4.ChkX.Caption := st;
              6: Form4.ChkY.Caption := st;
              7: Form4.ChkSt.Caption := st;
              8: clst(Form4.UniSt.Items, st, True);
              9: Form4.ChkAz.Caption := st;
              10: clst(Form4.UniAz.Items, st, True);
              11: Form4.BtCalcul.Caption := st;
              12: Form4.BtRaz.Caption := st;
              13: Form4.EdSt.Hint := st;
              end;
            end;
          end;
        end;
      end;
    end;
    CloseFile(fic);
  end
  else
    if nf = 0 then lngNT := True;
end;

function cas1(): Integer;
// Résolution du triangle dont on connait les 3 côtés (a, b, c)
// Solution unique si le triangle est possible
var
  pa, pb, pc, Ga, Gb, Gc: Real;  // Pour les angles en radian, appellation classique : a, b, c, A, B, C
  p: Real;
begin
  pa := DegToRad(Tvar[0, 0]); pb := DegToRad(Tvar[1, 0]); pc := DegToRad(Tvar[2, 0]);
  p := (pa + pb + pc)/2;  //Calcul du demi-périmètre
  if p >= Pi then
    Result := 1  // Le demi-périmètre d'un triangle sphérique ne peut pas dépasser Pi
  else
    if (pa >= p) or (pb >= p) or (pc >= p) then
      Result := 1 // Chaque coté d'un triangle ne peut pas dépasser le demi-périmètre (autre forme de l'inégalité triangulaire)
    else
    begin
      Ga := (Cos(pa) - Cos(pb)*Cos(pc))/Sin(pb)/Sin(pc);
      if Ga >= 1 then Ga := 0 else if Ga <= -1 then Ga := Pi else Ga := ArcCos(Ga);
      Gb := (cos(pb) - Cos(pc)*Cos(pa))/Sin(pc)/Sin(pa);
      if Gb >= 1 then Gb := 0 else if Gb <= -1 then Gb := Pi else Gb := ArcCos(Gb);
      Gc := (Cos(pc) - Cos(pa)*Cos(pb))/Sin(pa)/Sin(pb);
      if Gc >= 1 then Gc := 0 else if Gc <= -1 then Gc := Pi else Gc := ArcCos(Gc);
      Tvar[3, 0] := RadToDeg(Ga); Tvar[3, 1] := Tvar[3, 0];
      Tvar[4, 0] := RadToDeg(Gb); Tvar[4, 1] := Tvar[4, 0];
      Tvar[5, 0] := RadToDeg(Gc); Tvar[5, 1] := Tvar[5, 0];
      Result := 0;
    end;
end;

function cas3(): Integer;
// Résolution du triangle dont on connait 2 côtés et l'angle entre les côtés (a, b, C)
// Toujours une solution unique
var
  pa, pb, pc, Ga, Gb, Gc: Real;  // Pour les angles en radian, appellation classique : a, b, c, A, B, C
begin
  pa := DegToRad(Tvar[0, 0]); pb := DegToRad(Tvar[1, 0]); Gc := DegToRad(Tvar[5, 0]);
  pc := Cos(pa)*Cos(pb) + Sin(pa)*Sin(pb)*Cos(Gc);
  if pc >= 1 then
  begin
    pc := 0; Ga := Pi/2; Gb := Pi/2;
  end
  else
    if pc <= -1 then
    begin
      pc := Pi; Ga := Pi/2; Gb := Pi/2;
    end
    else
    begin
    pc := ArcCos(pc);
    Ga := (Cos(pa) - Cos(pb)*Cos(pc))/Sin(pb)/Sin(pc);
    if Ga >= 1 then Ga := 0 else if Ga <= -1 then Ga := Pi else Ga := ArcCos(Ga);
    Gb := (Cos(pb) - Cos(pc)*Cos(pa))/Sin(pc)/Sin(pa);
    if Gb >= 1 then Gb := 0 else if Gb <= -1 then Gb := Pi else Gb := ArcCos(Gb);
    end;
  Tvar[2, 0] := RadToDeg(pc); Tvar[2, 1] := Tvar[2, 0];
  Tvar[3, 0] := RadToDeg(Ga); Tvar[3, 1] := Tvar[3, 0];
  Tvar[4, 0] := RadToDeg(Gb); Tvar[4, 1] := Tvar[4, 0];
  Result := 0;
end;

function cas5(): Integer;
// Résolution du triangle dont on connait 2 côtés et l'angle à l'extrémité d'un côté (a, b, A)
// Repose sur la recherche de c dans l'équation trigonométrique E : cos a = cos b.cos c + sin b.sin c.cos A
// Nombre de solution : 0, 1, 2 ou une infinité
var
  pa, pb, pc, Ga, Gb, Gc: Real;  // Pour les angles en radian, appellation classique : a, b, c, A, B, C
  pc2, Gb2, Gc2: Real;           // Pour la seconde solution
  th: Real;
begin
  pa := DegToRad(Tvar[0, 0]); pb := DegToRad(Tvar[1, 0]); Ga := DegToRad(Tvar[3, 0]);
  if SameValue(pb, Pi/2) and SameValue(Ga, Pi/2) then
    if not SameValue(pa, Pi/2) then
      Result := 1 // L'angle pa doit être de Pi/2
    else
    begin         // E devient : 0 = 0, c peut être quelconque. C dépend de c (et vice-versa)
      pc := -Pi/2; Gb := Pi/2; Gc := -Pi/2;  // -Pi/2 est le codage de l'interdépendance
      Tvar[2, 0] := RadToDeg(pc); Tvar[2, 1] := Tvar[2, 0];
      Tvar[4, 0] := RadToDeg(Gb); Tvar[4, 1] := Tvar[4, 0];
      Tvar[5, 0] := RadToDeg(Gc); Tvar[5, 1] := Tvar[5, 0];
      Result := 0;
    end
  else
  begin
    th := Cos(pa)/Sqrt(Sqr(Cos(pb)) + Sqr(Sin(pb)*Cos(Ga)));
    if Abs(th) > 1 then
      Result := 1 // Pas de solution
    else
    begin
      pc := Arctan2(Sin(pb)*Cos(Ga), Cos(pb)) + Arccos(th);
      if (pc > Pi) or SameValue(pc, Pi) then pc := pc - 2*Pi;
      pc2 := Arctan2(Sin(pb)*Cos(Ga), Cos(pb)) - ArcCos(th);
      if (pc2 < -Pi) and not SameValue(pc2, -Pi) then pc2 := pc2 + 2*Pi;
      if pc < pc2 then  // Organisation des résultats en valeurs décroissantes
      begin
        th := pc; pc := pc2; pc2 := th;
      end;
      if ((pc < 0) or IsZero(pc)) and ((pc2 < 0) or IsZero(pc2)) then
        Result := 1 // Pas de solution, les résultats ne sont pas dans l'interval ]0, Pi[
      else
      begin
        if (pc2 < 0) or IsZero(pc2) then pc2 := pc; // pc2 n'est pas acceptable, une seule solution
        Gb := (Cos(pb) - Cos(pc)*Cos(pa))/Sin(pc)/Sin(pa);
        if Gb >= 1 then Gb := 0 else if Gb <= -1 then Gb := Pi else Gb := ArcCos(Gb);
        Gc := (Cos(pc) - Cos(pa)*Cos(pb))/Sin(pa)/Sin(pb);
        if Gc >= 1 then Gc := 0 else if Gc <= -1 then Gc := Pi else Gc := ArcCos(Gc);
        Gb2 := (Cos(pb) - Cos(pc2)*Cos(pa))/Sin(pc2)/Sin(pa);
        if Gb2 >= 1 then Gb2 := 0 else if Gb2 <= -1 then Gb2 := Pi else Gb2 := ArcCos(Gb2);
        Gc2 := (Cos(pc2) - Cos(pa)*Cos(pb))/Sin(pa)/Sin(pb);
        if Gc2 >= 1 then Gc2 := 0 else if Gc2 <= -1 then Gc2 := Pi else Gc2 := ArcCos(Gc2);
        Tvar[2, 0] := RadToDeg(pc); Tvar[2, 1] := RadToDeg(pc2);
        Tvar[4, 0] := RadToDeg(Gb); Tvar[4, 1] := RadToDeg(Gb2);
        Tvar[5, 0] := RadToDeg(Gc); Tvar[5, 1] := RadToDeg(Gc2);
        Result := 0;
      end;
    end;
  end;
end;  

function casGa(): Integer;
// Résolution du triangle plan dont on connait les 3 côtés (a, b, c)
// Solution unique si le triangle est possible
var
  pa, pb, pc, Ga, Gb, Gc: Real;  // Appellation classique : a, b, c, A, B, C
  p: Real;
begin
  pa := Tvar[0, 0]; pb := Tvar[1, 0]; pc := Tvar[2, 0];
  p := (pa + pb + pc)/2;  //Calcul du demi-périmètre
  if (pa >= p) or (pb >= p) or (pc >= p) then
    Result := 1 // Chaque coté d'un triangle ne peut pas dépasser le demi-périmètre (autre forme de l'inégalité triangulaire)
  else
  begin
    Ga := ArcCos((sqr(pb) + sqr(pc) - sqr(pa))/2/pb/pc);
    Gb := ArcCos((sqr(pc) + sqr(pa) - sqr(pb))/2/pc/pa);
    Gc := ArcCos((sqr(pa) + sqr(pb) - sqr(pc))/2/pa/pb);
    Tvar[3, 0] := RadToDeg(Ga); Tvar[3, 1] := Tvar[3, 0];
    Tvar[4, 0] := RadToDeg(Gb); Tvar[4, 1] := Tvar[4, 0];
    Tvar[5, 0] := RadToDeg(Gc); Tvar[5, 1] := Tvar[5, 0];
    Result := 0;
  end;
end;

function casGb(): Integer;
// Résolution du triangle plan dont on connait les 3 angles (A, B, C)
var
  pa, pb, pc, Ga, Gb, Gc: Real;  // Appellation classique : a, b, c, A, B, C
begin
  if not SameValue(Tvar[3, 0] + Tvar[4, 0] + Tvar[5, 0], 180) then
    Result := 1  // La somme des angles d'un triangle plan doit être égale à 180°
  else
  begin
    MessDlgPos(MTri[14], mtInformation, Form1.Left + xms, Form1.Top + yms);
    Ga := DegToRad(Tvar[3, 0]); Gb := DegToRad(Tvar[4, 0]); Gc := DegToRad(Tvar[5, 0]);
    pa := 0.000009;              // Equivalent à 1 mètre
    pb := pa*Sin(Gb)/Sin(Ga);
    pc := pa*Sin(Gc)/Sin(Ga);
    Tvar[0, 0] := pa; Tvar[0, 1] := Tvar[0, 0];
    Tvar[1, 0] := pb; Tvar[1, 1] := Tvar[1, 0];
    Tvar[2, 0] := pc; Tvar[2, 1] := Tvar[2, 0];
    Result := 0;
  end;
end;

function casGc(): Integer;
// Résolution du triangle plan dont on connait 2 côtés et l'angle entre les côtés (a, b, C)
// Toujours une solution unique
var
  pa, pb, pc, Ga, Gb, Gc: Real;  // Appellation classique : a, b, c, A, B, C
begin
  pa := Tvar[0, 0]; pb := Tvar[1, 0]; Gc := DegToRad(Tvar[5, 0]);
  pc := sqrt(sqr(pa) + sqr(pb) - 2*pa*pb*Cos(Gc));
  Ga := ArcCos((sqr(pb) + sqr(pc) - sqr(pa))/2/pb/pc);
  Gb := ArcCos((sqr(pc) + sqr(pa) - sqr(pb))/2/pc/pa);
  Tvar[2, 0] := pc; Tvar[2, 1] := Tvar[2, 0];
  Tvar[3, 0] := RadToDeg(Ga); Tvar[3, 1] := Tvar[3, 0];
  Tvar[4, 0] := RadToDeg(Gb); Tvar[4, 1] := Tvar[4, 0];
  Result := 0;
end;

function casGd(): Integer;
// Résolution du triangle plan dont on connait 2 angles et le côté entre les angles (c, A, B)
var
  pa, pb, pc, Ga, Gb, Gc: Real;  // Appellation classique : a, b, c, A, B, C
begin
  Gc := 180 - Tvar[3, 0] - Tvar[4, 0];
  if Gc <= 0 then
    Result := 1
  else
  begin
    pc := Tvar[2, 0]; Ga := DegToRad(Tvar[3, 0]); Gb := DegToRad(Tvar[4, 0]);
    Gc := DegToRad(Gc);
    pa := pc*Sin(Ga)/sin(Gc);
    pb := pc*Sin(Gb)/sin(Gc);
    Tvar[0, 0] := pa; Tvar[0, 1] := Tvar[0, 0];
    Tvar[1, 0] := pb; Tvar[1, 1] := Tvar[1, 0];
    Tvar[5, 0] := RadToDeg(Gc); Tvar[5, 1] := Tvar[5, 0];
    Result := 0;
  end;
end;

function casGe(): Integer;
// Résolution du triangle plan dont on connait 2 côtés et l'angle à l'extrémité d'un côté (a, b, A)
var
  pa, pb, pc, Ga, Gb, Gc: Real;  // Appellation classique : a, b, c, A, B, C
  dt: Real;                      // Déterminant
begin
  pa := Tvar[0, 0]; pb := Tvar[1, 0]; Ga := DegToRad(Tvar[3, 0]);
  if (Cos(Ga) < 0) and (pa < pb) or (pa < pb*Sin(Ga)) then
    Result := 1
  else
  begin
    dt := sqrt(sqr(pa) - sqr(pb*Sin(Ga)));
    pc := pb*Cos(Ga) + dt;
    Gb := ArcCos((sqr(pc) + sqr(pa) - sqr(pb))/2/pc/pa);
    Gc := ArcCos((sqr(pa) + sqr(pb) - sqr(pc))/2/pa/pb);
    Tvar[2, 0] := pc; Tvar[2, 1] := Tvar[2, 0];
    Tvar[4, 0] := RadToDeg(Gb); Tvar[4, 1] := Tvar[4, 0];
    Tvar[5, 0] := RadToDeg(Gc); Tvar[5, 1] := Tvar[5, 0];
    if pa < pb then
    begin
      pc := pb*Cos(Ga) - dt;
      Gb := ArcCos((sqr(pc) + sqr(pa) - sqr(pb))/2/pc/pa);
      Gc := ArcCos((sqr(pa) + sqr(pb) - sqr(pc))/2/pa/pb);
      Tvar[2, 1] := pc;
      Tvar[4, 1] := RadToDeg(Gb);
      Tvar[5, 1] := RadToDeg(Gc);
    end;
    Result := 0;
  end;
end;

function casGf(): Integer;
// Résolution du triangle plan dont on connait 2 angles et le côté à l'extrémité d'un angle (a, A, B)
var
  pa, pb, pc, Ga, Gb, Gc: Real;  // Appellation classique : a, b, c, A, B, C
begin
  Gc := 180 - Tvar[3, 0] - Tvar[4, 0];
  if Gc <= 0 then
    Result := 1
  else
  begin
    pa := Tvar[0, 0]; Ga := DegToRad(Tvar[3, 0]); Gb := DegToRad(Tvar[4, 0]);
    Gc := DegToRad(Gc);
    pb := pa*Sin(Gb)/Sin(Ga);
    pc := pa*Sin(Gc)/Sin(Ga);
    Tvar[1, 0] := pb; Tvar[1, 1] := Tvar[1, 0];
    Tvar[2, 0] := pc; Tvar[2, 1] := Tvar[2, 0];
    Tvar[5, 0] := RadToDeg(Gc); Tvar[5, 1] := Tvar[5, 0];
    Result := 0;
  end;
end;

procedure invi();
// Echange des paramètres 0/1 et 3/4
var
  i: Integer;
  m0, m3: Real;
begin
  for i := 0 to 1 do
  begin
    m0 := Tvar[0, i]; m3 := Tvar[3, i];
    Tvar[0, i] := Tvar[1, i]; Tvar[3, i] := Tvar[4, i];
    Tvar[1, i] := m0; Tvar[4, i] := m3;
  end;
end;

procedure invj();
// Echange des paramètres 1/2 et 4/5
var
  i: Integer;
  m1, m4: Real;
begin
  for i := 0 to 1 do
  begin
    m1 := Tvar[1, i]; m4 := Tvar[4, i];
    Tvar[1, i] := Tvar[2, i]; Tvar[4, i] := Tvar[5, i];
    Tvar[2, i] := m1; Tvar[5, i] := m4;
  end;
end;

procedure pol();
// Passage au triangle polaire
var
  i, j: Integer;
  m: Real;
begin
  // Angles supplémentaire
  for j := 0 to 1 do
    for i := 0 to 5 do
      Tvar[i, j] := 180 - Tvar[i, j];
  // Inversion des côtés et des angles
  for j := 0 to 1 do
    for i := 0 to 2 do
    begin
      m := Tvar[i, j]; Tvar[i,j] := Tvar[i + 3, j]; Tvar[i + 3, j] := m;
    end;
end;

procedure TForm1.ChkPaClick(Sender: TObject);
begin
  ChkClick(0);
end;

procedure TForm1.ChkPbClick(Sender: TObject);
begin
  ChkClick(1);
end;

procedure TForm1.ChkPcClick(Sender: TObject);
begin
  ChkClick(2);
end;

procedure TForm1.ChkGaClick(Sender: TObject);
begin
  ChkClick(3);
end;

procedure TForm1.ChkGbClick(Sender: TObject);
begin
  ChkClick(4);
end;

procedure TForm1.ChkGcClick(Sender: TObject);
begin
  ChkClick(5);
end;

procedure TForm1.ChkPa2Click(Sender: TObject);
begin
  Chk2Click(0);
  ChkClick(0);
end;

procedure TForm1.ChkPb2Click(Sender: TObject);
begin
  Chk2Click(1);
  ChkClick(1);
end;

procedure TForm1.ChkPc2Click(Sender: TObject);
begin
  Chk2Click(2);
  ChkClick(2);
end;

procedure TForm1.ChkGa2Click(Sender: TObject);
begin
  Chk2Click(3);
  ChkClick(3);
end;

procedure TForm1.ChkGb2Click(Sender: TObject);
begin
  Chk2Click(4);
  ChkClick(4);
end;

procedure TForm1.ChkGc2Click(Sender: TObject);
begin
  Chk2Click(5);
  ChkClick(5);
end;

procedure TForm1.EdPaExit(Sender: TObject);
begin
  EdExit(0);
end;

procedure TForm1.EdPbExit(Sender: TObject);
begin
  EdExit(1);
end;

procedure TForm1.EdPcExit(Sender: TObject);
begin
  EdExit(2);
end;

procedure TForm1.EdGaExit(Sender: TObject);
begin
  EdExit(3);
end;

procedure TForm1.EdGbExit(Sender: TObject);
begin
  EdExit(4);
end;

procedure TForm1.EdGcExit(Sender: TObject);
begin
  EdExit(5);
end;

procedure TForm1.UniPaChange(Sender: TObject);
begin
  UniChange(0);
end;

procedure TForm1.UniPbChange(Sender: TObject);
begin
  UniChange(1);
end;

procedure TForm1.UniPcChange(Sender: TObject);
begin
  UniChange(2);
end;

procedure TForm1.UniGaChange(Sender: TObject);
begin
  UniChange(3);
end;

procedure TForm1.UniGbChange(Sender: TObject);
begin
  UniChange(4);
end;

procedure TForm1.UniGcChange(Sender: TObject);
begin
  UniChange(5);
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
// Outil de mise au point pour afficher les valeurs calculées en pleine définition
begin
  if (Key = Ord('Y')) and (ssCtrl in Shift) then
  begin
    quits();        // Pour quitter un éventuel champ de saisie
    MessDlgPos(MTri[15]
        + #13#10'0 : ' + BoolToStr(Tbol2[0], True)+ ', ' + BoolToStr(Tbol[0], True)+ ', ' + FloatToStr(Tvar[0, 0])
        + #13#10'1 : ' + BoolToStr(Tbol2[1], True)+ ', ' + BoolToStr(Tbol[1], True)+ ', ' + FloatToStr(Tvar[1, 0])
        + #13#10'2 : ' + BoolToStr(Tbol2[2], True)+ ', ' + BoolToStr(Tbol[2], True)+ ', ' + FloatToStr(Tvar[2, 0])
        + #13#10'3 : ' + BoolToStr(Tbol2[3], True)+ ', ' + BoolToStr(Tbol[3], True)+ ', ' + FloatToStr(Tvar[3, 0])
        + #13#10'4 : ' + BoolToStr(Tbol2[4], True)+ ', ' + BoolToStr(Tbol[4], True)+ ', ' + FloatToStr(Tvar[4, 0])
        + #13#10'5 : ' + BoolToStr(Tbol2[5], True)+ ', ' + BoolToStr(Tbol[5], True)+ ', ' + FloatToStr(Tvar[5, 0]),
        mtInformation, Left + Width, Top);
  end;
end;

procedure TForm1.ConfChange(Sender: TObject);
// Changement de configuration
var
  fic: TextFile;
  lin, mot: String;
  i, j, k: Integer;
begin
  // Remise à zéro de toutes les fenêtres du programme
  if frm then   // Pour ne pas l'exécuter à l'initialisation quand les autres Form ne sont pas créées
  begin
    Form2.Hide;
    Form2.ChkAh.Show; Form2.EdAh.Show; Form2.UniAh.Show;
    Form2.ChkDc.Show; Form2.EdDc.Show; Form2.UniDc.Show;
    Form3.Hide;
    Form3.ChkHoTh.Checked := False;
    Form3.ChkDbl.Checked := False;
    Form3.ChkPrlx.Checked := True;
    Form4.Hide;
    Form4.ChkSt.Show; Form4.EdSt.Show; Form4.UniSt.Show;
    Form4.ChkAz.Show; Form4.EdAz.Show; Form4.UniAz.Show;
    Form4.Label3.Show;
    for i := 6 to 19 do
    begin
      LiC[i].Checked := False;
      LiE[i].Text := '';
      LiE[i].Modified := False;
      if (i >= 9) and (i < 14) or (i >= 18) then
      begin
        LiB[i].ItemIndex := 0;
        Unt[i] := nunt(LiB[i].Items[0]);
      end;
    end;
    Form2.AEdJo.Caption := '';
    Form2.AEdHo.Caption := '';
  end;
  Ah := 10; dc := 11; hr := 15; st := 18; Az := 19;
  for i := 0 to 5 do
  begin
    LiC[i].Checked := False;
    LiC2[i].Checked := False;
    LiC2[i].Visible := False;
    LiE[i].Text := '';
    LiE[i].Modified := False;
    LiB[i].Enabled := True;
//    Tbol[i] := False;
    Etiq[i] := '';
    Comp[i] := False;
    if i < 3 then
      clst(LiB[i].Items, LunB[i], False) // Réinitialise la liste d'unité de la boîte de sélection
    else
      Srot[i] := 0;
    Unt[i] := nunt(LiB[i].Items[0]);
  end;
  Trip := False;
  for i := 0 to 4 do     // Pas de donnée renvoyée vers les modules de calcul spécifique
    Mrv[i] := False;
  Info.Clear;
  if Conf.ItemIndex = 0 then
  begin                  // Cas du triangle sphérique de base
    Etiq[0] := 'a';
    Etiq[1] := 'b';
    Etiq[2] := 'c';
    Etiq[3] := 'A';
    Etiq[4] := 'B';
    Etiq[5] := 'C';
    Grot := 0;
    Info.Text := MTri[16];
  end
  else
  begin                  // Autres cas à lire dans le fichier de configuration
    AssignFile(fic, Fcf);
    Reset(fic);
    if vcf >= 1 then Readln(fic, lin); // Si la version n'est pas nulle, passer la première ligne
    while not Eof(fic) do // Recherche du paragraphe correspondant à la sélection
    begin
      Readln(fic, lin);
      if lin = Conf.Text then Break;
      while (lin <> '---') and not Eof(fic) do
        Readln(fic, lin);
    end;
    if Eof(fic) then
      MessDlgPos(MTri[17], mtError, Left + xms, Top + yms)
    else
    begin
      Readln(fic,lin); // Lecture de l'étiquette des angles
      j := 0;
      repeat
        i := Pos(',', lin);
        if i = 0 then i := Length(lin) + 1;
        if j < 6 then
          Etiq[j] := cadi(Copy(lin, 1, i - 1), j);
        Inc(j);
        Delete(lin, 1, i);
      until lin = '';
      Readln(fic,lin); // Lecture des booléens de complément
      for i := 1 to Length(lin) do
      begin
        if (i < 4) and (lin[i] = 'L') then Trip := True;
        if (i < 7) and (lin[i] = 'O') then Comp[i - 1] := True;
      end;
      if Trip then
        for i := 0 to 2 do
        begin
          Comp[i] := False; // Pas de complément des côtés pour un triangle plan
          for j := 0 to fLun - dLun do // Pas d'unité d'angle pour les côtés
          begin
            k := indx(LiB[i].Items, MTri[j + dLun]);
            if (k >= 0) and (j in [0, 1, 2, 3, 7, 8, 9, 10]) then
              LiB[i].Items.Delete(k);
          end;
          Unt[i] := nunt(LiB[i].Items[0]);
        end;
      Grot := 1;
      Readln(fic,lin); // Lecture des informations de signe
      for i := 1 to Length(lin) do
        if (i < 4) then
          case lin[i] of
            'Q': Srot[i + 2] := 2;
            'R': Srot[i + 2] := 1;
            'S': Srot[i + 2] := -1;
            'T': Srot[i + 2] := -2;
            else Grot := 0;
          end;
      if vcf >= 1 then
      begin
        Readln(fic,lin); // Lecture des unités
        j := 0;
        repeat
          i := Pos(',', lin);
          if i = 0 then i := Length(lin) + 1;
          mot := Trim(Copy(lin, 1, i - 1));
          if (j < 6) and (mot <> '') then Unt[j] := nunt(mot);
          Inc(j);
          Delete(lin, 1, i);
        until lin = '';
        Readln(fic,lin); // Lecture des valeurs
        j := 0;
        repeat
          i := Pos(',', lin);
          if i = 0 then i := Length(lin) + 1;
          mot := Trim(Copy(lin, 1, i - 1));
          if (j < 6) and (Unt[j] >= 0) and (mot <> '') then
          begin
            LiC[j].Checked := True;
            LiE[j].Text := mot;
            LiE[j].Modified := True;
            EdExit(j);
          end;
          Inc(j);
          Delete(lin, 1, i);
        until lin = '';
      end;
      Readln(fic,lin); // Lecture des indications
      while (lin <> '---') and not Eof(fic) do
      begin
        if (lin = '') or (lin[1] <> ';') then Info.Text := Info.Text + lin + #13;
        Readln(fic, lin);
      end;
      if Eof(fic) and ((lin = '') or (lin[1] <> ';')) then Info.Text := Info.Text + lin + #13;
    end;
    CloseFile(fic);
  end;
  //  MessDlgPos(Format(MTri[27], [ExtractFileName(Fcf)]), mtWarning, Form1.Left + xms, Form1.Top + yms);
  for i := 0 to 5 do
  begin
    LiC[i].Caption := Etiq[i];
    if Unt[i] < 0 then
      j := -1
    else
      j := indx(LiB[i].Items, MTri[Unt[i] + dLun]);
    if j < 0 then                        // Est-ce que Unt[i] se trouve dans la boîte de sélection ?
    begin                                // Non, on prend la première unité de la boîte
      LiB[i].ItemIndex := 0;
      Unt[i] := nunt(LiB[i].Items[0]);
      LiC[i].Checked := False;           // Et on ne prend pas en compte la valeur
      LiE[i].Text := '';
      LiE[i].Modified := False;
    end
    else                                 // Oui, on la sélectionne
      LiB[i].ItemIndex := j;
    LiE[i].Hint := chnt(i);
  end;
end;

procedure TForm1.BtCalculClick(Sender: TObject);
var
  chx: Word;
  i, p2, nbpar, cf, cont: Integer;
  mess, seq: String;
  su, sol, bl: Boolean;
  Tmin, Tmax: Real;
begin
  quits();               // Pour quitter un éventuel champ de saisie
  p2 := 1;
  nbpar := 0;
  cf := 0;
  for i := 0 to 5 do     // Calcul de la configuration
  begin
    if Tbol[i] then
    begin
      Inc(nbpar);
      cf := cf + p2;
    end;
    p2 := 2*p2;
  end;
  if nbpar < 3 then      // Vérification du nombre d'angles saisis
    MessDlgPos(MTri[18], mtError, Left + xms, Top + yms)
  else
  begin
    for i := 0 to 5 do   // Décoche la case s'il n'y a pas de valeur saisie
      if LiC[i].Checked and not Tbol[i] then LiC[i].Checked := False;
    if nbpar > 3 then    // Vérification du nombre d'angles saisis
      MessDlgPos(MTri[19], mtError, Left + xms, Top + yms)
    else
    begin
      for i := 0 to 5 do                // Décoche la case s'il n'y a pas de valeur saisie
        if LiC[i].Checked and not Tbol[i] then LiC[i].Checked := False;
      if Trip then cf := cf + 64;
      case cf of         // Acquisition de la séquence de traitement correspondant à la configuration
         7: seq := '1';
        11: seq := '5';
        19: seq := 'i5i';
        35: seq := '3';
        13: seq := 'j5j';
        21: seq := 'j3j';
        37: seq := 'ji5ij';
        14: seq := 'ij3ji';
        22: seq := 'ij5ji';
        38: seq := 'iji5iji';
        56: seq := 'p1p';
        25: seq := 'p5p';
        26: seq := 'pi5ip';
        28: seq := 'p3p';
        41: seq := 'pj5jp';
        42: seq := 'pj3jp';
        44: seq := 'pji5ijp';
        49: seq := 'pij3jip';
        50: seq := 'pij5jip';
        52: seq := 'piji5ijip';
         7 + 64: seq := 'A';
        11 + 64: seq := 'E';
        19 + 64: seq := 'iEi';
        35 + 64: seq := 'C';
        13 + 64: seq := 'jEj';
        21 + 64: seq := 'jCj';
        37 + 64: seq := 'jiEij';
        14 + 64: seq := 'ijCji';
        22 + 64: seq := 'ijEji';
        38 + 64: seq := 'ijiEiji';
        56 + 64: seq := 'B';
        25 + 64: seq := 'F';
        26 + 64: seq := 'iFi';
        28 + 64: seq := 'D';
        41 + 64: seq := 'jFj';
        42 + 64: seq := 'jDj';
        44 + 64: seq := 'jiFij';
        49 + 64: seq := 'ijDji';
        50 + 64: seq := 'ijFji';
        52 + 64: seq := 'ijiFiji';
      end;
      cont := 0;
      for i := 1 to Length(seq) do  // Exécution de la séquence de traitement
        case seq[i] of
          'i': invi();
          'j': invj();
          'p': begin
            pol();
            if cont > 1 then cont := cont + 10; // Pour future évolution vers un codage du message d'erreur
          end;
          '1': cont := cas1();
          '3': cont := cas3();
          '5': cont := cas5();
          'A': cont := casGa();
          'B': cont := casGb();
          'C': cont := casGc();
          'D': cont := casGd();
          'E': cont := casGe();
          'F': cont := casGf();
        end;
      if cont = 0 then
      begin                          // Pas d'erreur, affichage des résultats
        if ((cf = 7) or (cf = 7 + 64)) and (Grot <> 0) then   //Choix du signe des angles
        begin
          chx := SelBoxPos(MTri[13], Format(MTri[20], [Etiq[3], MTri[Unt[3] + dLun]]),
                           [chrt(-Tvar[3, 0], 3, prc), chrt(Tvar[3, 0], 3, prc)], 2, Left + xms, Top + yms);
          Grot := Srot[3] div Abs(Srot[3]);
          if chx = 1 then Grot := -Grot;
        end;
        su := True;      // A priori, solution unique
        for i := 0 to 5 do
        begin
          if cf mod 2 = 0 then                   // Est-ce un résultat ?
          begin                                  // i correspond à l'indice du résultat
            if (Tvar[i, 0] <> Tvar[i, 1]) and su then // Choix de la solution s'il y en a 2
            begin
              su := False;
              mess := Format(MTri[20], [Etiq[i], MTri[Unt[i] + dLun]]);
              bl := (Tvar[i, 0] < Tvar[i, 1]) xor Comp[i];
              if bl then
              begin
                Tmin := Tvar[i, 0]; Tmax := Tvar[i, 1];
              end
              else
              begin
                Tmin := Tvar[i, 1]; Tmax := Tvar[i, 0];
              end;
              if Comp[i] then
              begin
                Tmin := 90 - Tmin; Tmax := 90 - Tmax;
              end;
              chx := SelBoxPos(MTri[13], mess, [chrt(Tmin, i, prc), chrt(Tmax, i, prc)], 2, Left + xms, Top + yms);
              sol := (chx = 1) xor bl;  // sol est vrai si on choisit la solution Tvar[i, 1]
            end;
            if sol and not su then Tvar[i, 0] := Tvar[i, 1];
            bl := Tvar[i, 0] > -45;
            if bl then                   // Cas des résultats "normaux"
              seq := chrt(modr(i), i, prc)
            else                         // Cas des résultats symboliques
            begin
              p2 := 0;
              if i >= 3 then p2 := p2 + 1;                         // Angle
              if Comp[(i mod 3) + 3] then p2 := p2 + 2;            // Angle complémenté
              if Comp[i mod 3] then p2 := p2 + 4;                  // Côté complémenté
              if Grot*Srot[(i mod 3) + 3] = -1 then p2 := p2 + 8;  // Angle négatif
              if Grot*Srot[(i mod 3) + 3] = -2 then p2 := p2 + 16; // Angle > 180°
              case p2 of
                0, 1:   seq := Format('= %s',       [Etiq[(i + 3) mod 6]]);
                2, 3:   seq := Format('= 180 - %s', [Etiq[(i + 3) mod 6]]);
                4, 5:   seq := Format('= 90 - %s',  [Etiq[(i + 3) mod 6]]);
                6, 13:  seq := Format('= %s - 90',  [Etiq[(i + 3) mod 6]]);
                7, 12:  seq := Format('= %s + 90',  [Etiq[(i + 3) mod 6]]);
                8, 9:   seq := Format('= -%s',      [Etiq[(i + 3) mod 6]]);
                10, 19: seq := Format('= %s + 180', [Etiq[(i + 3) mod 6]]);
                11, 18: seq := Format('= %s - 180', [Etiq[(i + 3) mod 6]]);
                14, 15: seq := Format('= -90 - %s', [Etiq[(i + 3) mod 6]]);
                16, 17: seq := Format('= 360 - %s', [Etiq[(i + 3) mod 6]]);
                20:     seq := Format('= %s - 270', [Etiq[(i + 3) mod 6]]);
                21:     seq := Format('= %s + 270', [Etiq[(i + 3) mod 6]]);
                22, 23: seq := Format('= 270 - %s', [Etiq[(i + 3) mod 6]]);
              end;
            end;
            LiE[i].Text := seq;
            if bl and LiC2[i].Checked then Tbol2[i] := True;
            LiE[i].Modified := False;
            LiB[i].Enabled := bl;
            if bl then
              LiB[i].Text := MTri[Unt[i] + dLun]
            else
              LiB[i].ItemIndex := 0;
          end;
          cf := cf div 2;
        end;
      end
      else
        MessDlgPos(MTri[21], mtWarning, Left + xms, Top + yms);
    end;
  end;
end;

procedure TForm1.BtRazClick(Sender: TObject);
var
  i: Integer;
begin
  for i := 0 to 5 do
    if not Tbol[i] then
    begin
      LiE[i].Text := '';
      LiE[i].Modified := False;
      Tbol2[i] := False;
    end;
end;

procedure chgConf();
var
  fic: TextFile;
  pl: Boolean;
  lin: String;
begin
  if FileExists(Fcf) then
  begin                        // Le fichier de configuration a été trouvé
    AssignFile(fic, Fcf);
    Reset(fic);
    pl := True;                // On va lire la première ligne
    while not Eof(fic) do
    begin
      Readln(fic, lin);
      if pl and (Pos('TriSph', lin) > 0) then
      begin                    // La première ligne contient une information de version
        try
          vcf := StrToInt(Copy(lin, Pos('TriSph', lin) + 6, 1));
        except
          vcf := 1;            // Si l'information de version est incorrecte on prend 1
        end;
        if vcf > 1 then        // Vérification du niveau de version
        begin
          MessDlgPos(Format(MTri[26], [vcf]), mtWarning, Form1.Left + xms, Form1.Top + yms);
          Break;
        end;
        Readln(fic, lin);
        pl := False;           // La première ligne est lue
      end;
      Form1.Conf.Items.Add(lin);     // Ajoute le nom de la configuration dans la boîte de sélection
      while (lin <> '---') and not Eof(fic) do
        Readln(fic, lin);
    end;
    CloseFile(fic);
  end
  else
    MessDlgPos(Format(MTri[27], [ExtractFileName(Fcf)]), mtWarning, Form1.Left + xms, Form1.Top + yms);
  Form1.Conf.ItemIndex := 0;
  Form1.ConfChange(nil);
end;

procedure TForm1.MConstClick(Sender: TObject);
var
  Fray: TForm;
  EdRay, EdApp, EdOpt: TEdit;
  CBFcf: TComboBox;
  Fini: TIniFile;
  LstFic: TStrings;
  EnrR: TSearchRec;
  Dim: Tpoint;
  i, nb, ilg, esph, espv, finh, finv: Integer;
  vl: Real;
  fc: String;
begin
  if men then // Sur Mac, pour ne pas avoir plusieur fenêtre
  begin
    men := False;
    {$IFDEF WIN32}
    Fini := TIniFile.Create(GetCurrentDir + '\TriSph.ini');
    {$ENDIF}
    {$IFDEF LINUX}
    Fini := TIniFile.Create(ExtractFilePath(ParamStr(0)) + 'TriSph.ini');
    {$ENDIF}
    {$IFDEF DARWIN}
    Fini := TIniFile.Create(ExtractFilePath(ParamStr(0)) + '../Resources/TriSph.ini');
    {$ENDIF}
    Fray := TForm.Create(Application);
    with Fray do
      try
        BorderStyle := bsDialog;
        Caption := MTri[22];
        Left := Form1.Left + xms;
        Top := Form1.Top + yms;
        Dim := DimT('X', Canvas);
        esph := MulDiv(4, Dim.X, 2);
        espv := MulDiv(1, Dim.Y, 2);
        with TLabel.Create(Fray) do
        begin
          Parent := Fray;
          Caption := MTri[23];
          Left := esph;
          Top := MulDiv(3, espv, 2);
          finh := Left + DimT(Caption, Canvas).X;
        end;
        EdRay := TEdit.Create(Fray);
        with EdRay do
        begin
          Parent := Fray;
          Top := espv;
          Text := FlToSt(rayu, prc);
          finv := Top + Height;
        end;
        with TLabel.Create(Fray) do
        begin
          Parent := Fray;
          Caption := MTri[51];
          Left := esph;
          Top := finv + MulDiv(3, espv, 2);
          finh := Max(finh, Left + DimT(Caption, Canvas).X);
        end;
        CBFcf := TComboBox.Create(Fray);
        with CBFcf do
        begin
          Parent := Fray;
          Style := csDropDownList;
          Top := finv + espv;
          LstFic := TStringList.Create;
          nb := Fini.ReadInteger('LANG', 'Nb_lng', 0);
          ilg := Fini.ReadInteger('LANG', 'Lng_ind', 1);
          if nb in [1..5] then
            for i := 1 to nb do
              if i <> ilg then
                LstFic.Add(Format('TriSph%s.cnf', [Fini.ReadString('LANG', 'Ext' + IntToStr(i), '')]));
          {$IFDEF WIN32}
          if FindFirst(GetCurrentDir + '\*.cnf', faAnyFile, EnrR) = 0 then
          begin
            repeat
              if (EnrR.Attr <> faDirectory) and (LstFic.IndexOf(EnrR.Name) < 0) then
          {$ENDIF}
          {$IFDEF LINUX}
          if FindFirst(ExtractFilePath(ParamStr(0)) + '*.cnf', faAnyFile, EnrR) = 0 then
          begin
            repeat
              if (EnrR.Attr <> faDirectory) and (indx(LstFic, EnrR.Name) < 0) then
          {$ENDIF}
          {$IFDEF DARWIN}
          if FindFirst(ExtractFilePath(ParamStr(0)) + '../Resources/*.cnf', faAnyFile, EnrR) = 0 then
          begin
            repeat
              if (EnrR.Attr <> faDirectory) and (indx(LstFic, EnrR.Name) < 0) then
          {$ENDIF}
                Items.Add(EnrR.Name);
            until FindNext(EnrR) <> 0;
            FindClose(EnrR);
          end;
          LstFic.Free;
          fc := Fini.ReadString('CONST', 'Fic_conf', 'TriSph.cnf');
          if fc = 'TriSph.cnf' then
            fc := Format('TriSph%s.cnf', [Fini.ReadString('LANG', 'Ext' + IntToStr(ilg), '')]);
          {$IFDEF WIN32}
          ItemIndex := Items.IndexOf(fc);
          {$ELSE}
          ItemIndex := indx(Items, fc);
          {$ENDIF}
          finv := Top + Height;
        end;
        with TLabel.Create(Fray) do
        begin
          Parent := Fray;
          Caption := MTri[52];
          Left := esph;
          Top := finv + MulDiv(3, espv, 2);
          finh := Max(finh, Left + DimT(Caption, Canvas).X);
        end;
        EdApp := TEdit.Create(Fray);
        with EdApp do
        begin
          Parent := Fray;
          Width := CBFcf.Width;
          Top := finv + espv;
          Text := App;
          finv := Top + Height;
        end;
        with TLabel.Create(Fray) do
        begin
          Parent := Fray;
          Caption := MTri[53];
          Left := esph;
          Top := finv + MulDiv(3, espv, 2);
          finh := Max(finh, Left + DimT(Caption, Canvas).X);
        end;
        EdOpt := TEdit.Create(Fray);
        with EdOpt do
        begin
          Parent := Fray;
          Top := finv + espv;
          Text := Opt;
          finv := Top + Height;
        end;
        i := finh + esph;
        EdRay.Left := i;
        finh := i + EdRay.Width;
        CBFcf.Left := i;
        finh :=  Max(finh, i + CBFcf.Width);
        EdApp.Left := i;
        finh :=  Max(finh, i + EdApp.Width);
        EdOpt.Left := i;
        finh :=  Max(finh, i + EdOpt.Width);
        with TButton.Create(Fray) do
        begin
          Parent := Fray;
          Caption := MTri[12];
          Default := True;
          Left := (finh + esph - Width) div 2 ;
          Top := finv + espv;
          finv := Top + Height;
          ModalResult := mrOK;
        end;
        ClientWidth := finh + esph;
        ClientHeight := finv + espv;
        if ShowModal = mrOK then
        begin
          Val(EdRay.Text, vl, i);
          if (i = 0) and (vl > 0) then
          begin
            Fini.WriteFloat('CONST', 'Rayon_util', vl);
            rayu := vl;
            for i := 0 to 2 do
              UniChange(i);
          end
          else
            MessDlgPos(MTri[30], mtError, Left + xms, Top + yms);
          Form1.Caption := 'TriSph - ' + CBFcf.Text;
          fc := Format('TriSph%s.cnf', [Fini.ReadString('LANG', 'Ext' + IntToStr(ilg), '')]);
          {$IFDEF WIN32}
          Fcf := GetCurrentDir + '\' + CBFcf.Text;
          if CompareText(CBFcf.Text, fc) = 0 then
          {$ENDIF}
          {$IFDEF LINUX}
          Fcf := ExtractFilePath(ParamStr(0)) + CBFcf.Text;
          if CBFcf.Text = fc then
          {$ENDIF}
          {$IFDEF DARWIN}
          Fcf := ExtractFilePath(ParamStr(0)) + '../Resources/' + CBFcf.Text;
          if CBFcf.Text = fc then
          {$ENDIF}
            Fini.WriteString('CONST', 'Fic_conf', 'TriSph.cnf')
          else
            Fini.WriteString('CONST', 'Fic_conf', CBFcf.Text);
          for i := Conf.Items.Count - 1 downto 1 do   // Vide la ComboBox Conf sauf le premier item
            Conf.Items.Delete(i);
          chgConf();
          if (App <> EdApp.Text) and
            (SelBoxPos(MTri[11], Format(MTri[55], [EdApp.Text, App]), [MTri[54], MTri[12]], 2, Left + xms, Top + yms) = 2) then
          begin
            App := EdApp.Text;
            Fini.WriteString('CONST', 'App_conf', EdApp.Text);
          end;
          if (Opt <> EdOpt.Text) and
            (SelBoxPos(MTri[11], Format(MTri[56], [Opt, EdOpt.Text]), [MTri[54], MTri[12]], 2, Left + xms, Top + yms) = 2) then
          begin
            Opt := EdOpt.Text;
            Fini.WriteString('CONST', 'Opt_conf', EdOpt.Text);
          end;
        end;
      finally
        Fray.Free;
      end;
    Fini.Free;
    men := True;
  end;
end;

procedure TForm1.BtConfigClick(Sender: TObject);
var
  Proc: Tprocess;
begin
  Proc := Tprocess.Create(nil);
  {$IF DEFINED(WIN32) OR DEFINED(DARWIN)}
  Proc.Executable := App;
  if Opt <> '' then
    Proc.Parameters.Add(Opt);
  Proc.Parameters.Add(Fcf);
  {$ENDIF}
  {$IFDEF LINUX}
  if Opt = '' then
    Proc.CommandLine := App + ' ' + Fcf
  else
    Proc.CommandLine := App + ' ' + Opt + ' ' + Fcf;
  {$ENDIF}
  try
    Proc.Execute;
  except
    MessDlgPos(Format(MTri[24], [App]), mtError, Left + xms, Top + yms);
  end;
  Proc.free;
end;

procedure TForm1.MAideClick(Sender: TObject);
begin
  {$IF DEFINED(WIN32) OR DEFINED(LINUX)}
  if not OpenDocument(ExtractFilePath(ParamStr(0)) + Format('Lisezmoi%s.pdf', [Elng])) then
  {$ENDIF}
  {$IFDEF DARWIN}
  if not FileExists(ExtractFilePath(ParamStr(0)) + Format('../Resources/Lisezmoi%s.pdf', [Elng])) or
     not OpenDocument(ExtractFilePath(ParamStr(0)) + Format('../Resources/Lisezmoi%s.pdf', [Elng])) then
  {$ENDIF}
    MessDlgPos(Format(MTri[25], [Elng]), mtError, Left + xms, Top + yms);
end;

function TForm1.{%H-}FormHelp(Command: Word; Data: PtrInt; var CallHelp: Boolean
  ): Boolean;
begin
  MaideClick(nil);
end;

procedure TForm1.MAPropClick(Sender: TObject);
begin
  MessDlgPos(MTri[57], mtInformation, Left + xms, Top + yms);
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  Fini: TIniFile;
  Mitem: TMenuItem;
  ca, cd: Longint;
  i, j: Integer;
begin
  DefaultFormatSettings.DecimalSeparator := '.';
  // Lecture du fichier ini
  {$IFDEF WIN32}
  Fini := TIniFile.Create(GetCurrentDir + '\TriSph.ini');
  App := Fini.ReadString('CONST', 'App_conf', 'notepad');
  Opt := Fini.ReadString('CONST', 'Opt_conf', '');
  {$ENDIF}
  {$IFDEF LINUX}
  Fini := TIniFile.Create(ExtractFilePath(ParamStr(0)) + 'TriSph.ini');
  App := Fini.ReadString('CONST', 'App_conf', 'leafpad');
  Opt := Fini.ReadString('CONST', 'Opt_conf', '');
  {$ENDIF}
  {$IFDEF DARWIN}
  Fini := TIniFile.Create(ExtractFilePath(ParamStr(0)) + '../Resources/TriSph.ini');
  App := Fini.ReadString('CONST', 'App_conf', 'open');
  Opt := Fini.ReadString('CONST', 'Opt_conf', '-e');
  {$ENDIF}
  Elng := '';
  j := Fini.ReadInteger('LANG', 'Nb_lng', 0);
  if j in [1..5] then
  begin
    for i := 1 to j do
    begin
      Mitem := TMenuItem.Create(MLang);
      Mitem.Caption := Fini.ReadString('LANG', 'Lng' + IntToStr(i), '');
      Mitem.Tag := i - 1;
      Mitem.OnClick := ChangeLng;
      MLang.Add(Mitem);
    end;
    i := Fini.ReadInteger('LANG', 'Lng_ind', 1);
    if i in [1..j] then
    begin
      MLang[i - 1].Checked := True;
      Elng := Fini.ReadString('LANG', 'Ext' + IntToStr(i), '');
    end;
    MLang.Visible := Fini.ReadBool('LANG', 'Visib', True);
  end
  else
  begin
    MLang.Visible := False;
    Elng := '';
  end;
  Fcf := Fini.ReadString('CONST', 'Fic_conf', 'TriSph.cnf');
  if Fcf = 'TriSph.cnf' then
    Fcf := Format('TriSph%s.cnf', [Elng]);
  Caption := 'TriSph - ' + Fcf;
  {$IFDEF WIN32}
  Fcf := GetCurrentDir + '\' + Fcf;
  {$ENDIF}
  {$IFDEF LINUX}
  Fcf := ExtractFilePath(ParamStr(0)) + Fcf;
  {$ENDIF}
  {$IFDEF DARWIN}
  Fcf := ExtractFilePath(ParamStr(0)) + '../Resources/' + Fcf;
  {$ENDIF}
  rayu := Fini.ReadFloat('CONST', 'Rayon_util', 1);
  if rayu <= 0 then rayu := 1;
  Fini.Free;
  Left := 160; Top := 180;
  if Elng <> '' then clng(0); // Met en place le changement de langue pour les messages de la Form1
  if Elng <> '' then clng(1); // Met en place le changement de langue pour les objets de la Form1
  // Calcul de la couleur intermédiaire entre clForm et clTriA
  // clTriA est la couleur des Edit quand ils sont en valeur d'entrée
  ca := ColorToRGB(clTriA);
  cd := ColorToRGB(clForm);
  Tri1 := Longint(GetBValue(ca) + GetBValue(cd)) shr 1;
  Tri1 := Longint(GetGValue(ca) + GetGValue(cd)) shr 1 or Tri1 shl 8;
  Tri1 := Longint(GetRValue(ca) + GetRValue(cd)) shr 1 or Tri1 shl 8;
  // Mise en place des tableaux pour accéder aux objets par un index
  LiC[0] := ChkPa; LiC[1] := ChkPb; LiC[2] := ChkPc; LiC[3] := ChkGa; LiC[4] := ChkGb; LiC[5] := ChkGc;
  LiC2[0] := ChkPa2; LiC2[1] := ChkPb2; LiC2[2] := ChkPc2; LiC2[3] := ChkGa2; LiC2[4] := ChkGb2; LiC2[5] := ChkGc2;
  LiE[0] := EdPa; LiE[1] := EdPb; LiE[2] := EdPc; LiE[3] := EdGa; LiE[4] := EdGb; LiE[5] := EdGc;
  LiB[0] := UniPa; LiB[1] := UniPb; LiB[2] := UniPc; LiB[3] := UniGa; LiB[4] := UniGb; LiB[5] := UniGc;
  // Mémorisation des listes d'unités des boîtes de sélection
  for i := 0 to 2 do
    for j := 0 to LiB[i].Items.Count - 1 do
      if j = 0 then
        LunB[i] := LiB[i].Items[0]
      else
        LunB[i] := LunB[i] + '|' + LiB[i].Items[j];
  {$IF DEFINED(LINUX) OR DEFINED(DARWIN)}
  // Ajustement de la taille des Edit pour afficher entièrement les valeurs
  aged := Canvas.TextWidth(' -888°88°88.88 ') - EdPa.Width;
  Width := Width + aged;
  Label2.Left := Label2.Left + aged div 2;
  Label3.Left := Label3.Left + aged;
  BtCalcul.Width := BtCalcul.Width + aged;
  for i := 0 to 5 do
  begin
    LiE[i].Width := LiE[i].Width + aged;
    LiB[i].Left := LiB[i].Left + aged;
  end;
  {$ENDIF}
  {$IFDEF LINUX}
  for i := 0 to 5 do
  begin
    LiC2[i].Left := LiC2[i].Left - 3;
    LiC2[i].Width := 18;
  end;
  {$ENDIF}
  {$IFDEF DARWIN}
  // Ajustement de la taille des ComboBox pour afficher entièrement les unités
  Width := Width + agcb;
  Label3.Left := Label3.Left + agcb div 2;
  BtCalcul.Width := BtCalcul.Width + agcb;
  for i := 0 to 5 do
  begin
    LiC2[i].Left := LiC2[i].Left - 2;
    LiC2[i].Width := 18;
    LiB[i].Width := LiB[i].Width + agcb;
  end;
  // Ajustement de la hauteur (pas de menu)
  Height := Height - 20;
  {$ENDIF}
  chgConf();
  frm := True;
end;

procedure TForm1.ChangeLng(Sender: TObject);
var
  Fini: TIniFile;
  i: Integer;
begin
  for i := 1 to MLang.Count do
    MLang[i - 1].Checked := False;
  i := TMenuItem(Sender).Tag;
  MLang[i].Checked := True;
  {$IFDEF WIN32}
  Fini := TIniFile.Create(GetCurrentDir + '\TriSph.ini');
  {$ENDIF}
  {$IFDEF LINUX}
  Fini := TIniFile.Create(ExtractFilePath(ParamStr(0)) + 'TriSph.ini');
  {$ENDIF}
  {$IFDEF DARWIN}
  Fini := TIniFile.Create(ExtractFilePath(ParamStr(0)) + '../Resources/TriSph.ini');
  {$ENDIF}
  MessDlgPos(Fini.ReadString('LANG', 'Mes' + IntToStr(i + 1), 'Changement de langue au prochain lancement'),
             mtInformation, Left + xms, Top + yms);
  Fini.WriteInteger('LANG', 'Lng_ind', i + 1);
  Fini.Free;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  if lngNT then MessDlgPos('Fichier Langage' + Elng + '.lgn non trouvé',
                            mtWarning, Form1.Left + xms, Form1.Top + yms);
  lngNT := False;
end;

procedure TForm1.FormWindowStateChange(Sender: TObject);
begin
  case WindowState of
    wsMinimized: begin
      fm2x := False; fm3x := False; fm4x := False; // Juste pour simplifier la compilation conditionnelle
      {$IF DEFINED(LINUX) OR DEFINED(DARWIN)}
      if Form2.Visible then
      begin
        fm2x := True;
        Form2.Hide;
      end;
      if Form3.Visible then
      begin
        fm3x := True;
        Form3.Hide;
      end;
      if Form4.Visible then
      begin
        fm4x := True;
        Form4.Hide;
      end;
      {$ENDIF}
    end;
    wsNormal: begin
      {$IF DEFINED(LINUX) OR DEFINED(DARWIN)}
      if fm2x then Form2.Show;
      if fm3x then Form3.Show;
      if fm4x then Form4.Show;
      {$ENDIF}
      Form1.Setfocus;
    end;
  end;
end;

procedure TForm1.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  Form2.Free;
  Form3.Free;
  Form4.Free;
  CloseAction := caFree;
end;

initialization
  {$I graph.lrs}

end.
