{
Copyright (c) 2013 Yvon Massé
Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
}

unit Unit4;
{$mode delphi}

interface

uses
  SysUtils, Classes, Forms, StdCtrls, Math;

type  { TForm4 }
  TForm4 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    ChkG: TCheckBox;
    ChkX: TCheckBox;
    ChkY: TCheckBox;
    ChkSt: TCheckBox;
    ChkAz: TCheckBox;
    EdG: TEdit;
    EdX: TEdit;
    EdY: TEdit;
    EdSt: TEdit;
    EdAz: TEdit;
    UniSt: TComboBox;
    UniAz: TComboBox;
    BtCalcul: TButton;
    BtRaz: TButton;
    procedure ChkGClick(Sender: TObject);
    procedure ChkXClick(Sender: TObject);
    procedure ChkYClick(Sender: TObject);
    procedure ChkStClick(Sender: TObject);
    procedure ChkAzClick(Sender: TObject);
    procedure EdGExit(Sender: TObject);
    procedure EdXExit(Sender: TObject);
    procedure EdYExit(Sender: TObject);
    procedure EdStExit(Sender: TObject);
    procedure EdAzExit(Sender: TObject);
    procedure UniStChange(Sender: TObject);
    procedure UniAzChange(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure BtCalculClick(Sender: TObject);
    procedure BtRazClick(Sender: TObject);
    function FormHelp({%H-}Command: Word; {%H-}Data: PtrInt; var {%H-}CallHelp: Boolean
      ): Boolean;
    procedure FormCreate(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

const
  MPro_0 = 'Données insuffisantes pour en calculer d’autres';
  MPro_1 = 'Trop de données, elles peuvent être incohérentes';
  MPro_2 = 'Site négatif ou nul';
  MPro_3 = 'Valeur de X :';
  MPro_4 = 'Valeur de Y :';
{
  MPro_5 = ;
  MPro_6 = ;
  MPro_7 = ;
  MPro_8 = ;
  MPro_9 = ;
}
  mMPro = 4;

var
  Form4: TForm4; 
  st: Integer = 18;
  Az: Integer = 19;
  MPro: Array[0..mMPro] of String =
    (MPro_0, MPro_1, MPro_2, MPro_3, MPro_4//, MPro_5, MPro_6, MPro_7, MPro_8, MPro_9,
    );

implementation

uses Unit1;

{$R *.lfm} { TForm4 }

procedure TForm4.ChkGClick(Sender: TObject);
begin
  ChkClick(15);
end;

procedure TForm4.ChkXClick(Sender: TObject);
begin
  ChkClick(16);
end;

procedure TForm4.ChkYClick(Sender: TObject);
begin
  ChkClick(17);
end;

procedure TForm4.ChkStClick(Sender: TObject);
begin
  ChkClick(18);
end;

procedure TForm4.ChkAzClick(Sender: TObject);
begin
  ChkClick(19);
end;

procedure TForm4.EdGExit(Sender: TObject);
begin
  EdExit(15);
end;

procedure TForm4.EdXExit(Sender: TObject);
begin
  EdExit(16);
end;

procedure TForm4.EdYExit(Sender: TObject);
begin
  EdExit(17);
end;

procedure TForm4.EdStExit(Sender: TObject);
begin
  EdExit(18);
end;

procedure TForm4.EdAzExit(Sender: TObject);
begin
  EdExit(19);
end;

procedure TForm4.UniStChange(Sender: TObject);
begin
  UniChange(18);
end;

procedure TForm4.UniAzChange(Sender: TObject);
begin
  UniChange(19);
end;

procedure TForm4.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState
  );
// Outil de mise au point pour afficher les valeurs calculées en pleine définition
begin
  if (Key = Ord('Y')) and (ssCtrl in Shift) then
  begin
    quits();        // Pour quitter un éventuel champ de saisie
    MessDlgPos(MTri[15]
        + #13#10'15 : ' + BoolToStr(Tbol[15], True)+ ', ' + FloatToStr(Tvar[15, 0])
        + #13#10'16 : ' + BoolToStr(Tbol[16], True)+ ', ' + FloatToStr(Tvar[16, 0])
        + #13#10'17 : ' + BoolToStr(Tbol[17], True)+ ', ' + FloatToStr(Tvar[17, 0])
        + #13#10'18 : ' + BoolToStr(Tbol[18], True)+ ', ' + FloatToStr(Tvar[18, 0])
        + #13#10'19 : ' + BoolToStr(Tbol[19], True)+ ', ' + FloatToStr(Tvar[19, 0]),
        mtInformation, Left + Width, Top);
  end;
end;

procedure TForm4.BtCalculClick(Sender: TObject);
var
  i, p2, cf: Integer;
  rc: Real;
  psb, stp: Boolean;
begin
  quits();            // Pour quitter un éventuel champ de saisie
  p2 := 1; cf := 0;
  for i := 15 to 17 do  // Calcul de la configuration
  begin
    if Tbol[i] then cf := cf + p2;
    p2 := 2*p2;
  end;
  if (st < 6) then
    if Tbol2[st] then cf := cf + p2 else
  else
    if Tbol[st] then cf := cf + p2;
  p2 := 2*p2;
  if (Az < 6) then
    if Tbol2[Az] then cf := cf + p2 else
  else
    if Tbol[Az] then cf := cf + p2 else;
  case cf of    // Traitement des configurations avec manque de données
    0, 1, 2, 3, 4, 5, 6, 8, 9, 10, 12, 16, 17, 18, 20, 24:
      MessDlgPos(MPro[0], mtError, Left + xms, Top + yms);
    else begin
      for i := 15 to 19 do                // Décoche la case s'il n'y a pas de valeur saisie
        if LiC[i].Checked and not Tbol[i] then LiC[i].Checked := False;
      if (st < 6) and LiC2[st].Checked and not Tbol2[st] then LiC2[st].Checked := False;
      if (Az < 6) and LiC2[Az].Checked and not Tbol2[Az] then LiC2[Az].Checked := False;
      psb := True; stp := True;
      case cf of
        14, 13, 11, 28, 26, 25: stp := modr(st) > 0;
      end;
      if stp then
      begin
        case cf of    // Traitement des autres configurations
          7, 14: begin       // Calcul de l'azimut
            Tvar[Az, 0] := RadToDeg(ArcTan2(Tvar[16, 0], Tvar[17, 0]));
            afrt(Az);
          end;
          13: begin          // Calcul de X
            rc := Sqr(Tvar[15, 0]/Tan(DegToRad(modr(st)))) - Sqr(Tvar[17, 0]);
            psb := rc > 0;
            if psb then
            begin
              Tvar[16, 0] := Sqrt(rc);
              if SelBoxPos(MTri[13], MPro[3],
                           [chrt(Tvar[16, 0], 16, prc), chrt(-Tvar[16, 0], 16, prc)], 2, Left + xms, Top + yms) = 2 then
                Tvar[16, 0] := -Tvar[16, 0];
              afrt(16);
            end;
          end;
          11: begin          // Calcul de Y
            rc := Sqr(Tvar[15, 0]/Tan(DegToRad(modr(st)))) - Sqr(Tvar[16, 0]);
            psb := rc >= 0;
            if psb then
            begin
              Tvar[17, 0] := Sqrt(rc);
              if SelBoxPos(MTri[13], MPro[4],
                           [chrt(Tvar[17, 0], 17, prc), chrt(-Tvar[17, 0], 17, prc)], 2, Left + xms, Top + yms) = 2 then
                Tvar[17, 0] := -Tvar[17, 0];
              afrt(17);
            end;
          end;
          21, 28: begin      // Calcul de X
            psb := Tvar[17, 0]*Cos(DegToRad(modr(Az))) > 0;
            if psb then
            begin
              Tvar[16, 0] := Tvar[17, 0]*Tan(DegToRad(modr(Az)));
              afrt(16);
            end;
          end;
          19, 26: begin      // Calcul de Y
            psb := Tvar[16, 0]*Sin(DegToRad(modr(Az))) > 0;
            if psb then
            begin
              Tvar[17, 0] := Tvar[16, 0]*Cos(DegToRad(modr(Az)))/Sin(DegToRad(modr(Az)));
              afrt(17);
            end;
          end;
          25: begin          // Calcul de X
            Tvar[16, 0] := Tvar[15, 0]*Sin(DegToRad(modr(Az)))/Tan(DegToRad(modr(st)));
            afrt(16);
          end;
        end;
        if psb then
          case cf of
            7, 21, 19: begin // Calcul du site
              Tvar[st,0] := RadToDeg(ArcTan(Tvar[15, 0]/Sqrt(Sqr(Tvar[16, 0]) + Sqr(Tvar[17, 0]))));
              afrt(st);
            end;
            14, 28, 26: begin // Calcul de la longueur du gnomon
              Tvar[15, 0] := Sqrt(Sqr(Tvar[16, 0]) + Sqr(Tvar[17, 0]))*Tan(DegToRad(modr(st)));
              afrt(15);
            end;
            13, 11: begin    // Calcul de l'azimut
              Tvar[Az, 0] := RadToDeg(ArcTan2(Tvar[16, 0], Tvar[17, 0]));
              afrt(Az);
            end;
            25: begin        // Calcul de Y
              Tvar[17, 0] := Tvar[15, 0]*Cos(DegToRad(modr(Az)))/Tan(DegToRad(modr(st)));
              afrt(17);
            end;
            else MessDlgPos(MPro[1], mtError, Left + xms, Top + yms);
          end
        else
          MessDlgPos(MTri[21], mtWarning, Left + xms, Top + yms);
      end
      else
        MessDlgPos(MPro[2], mtError, Left + xms, Top + yms);
    end;
  end;
end;

procedure TForm4.BtRazClick(Sender: TObject);
var
  i: Integer;
begin
  quits();                // Pour quitter un éventuel champ de saisie
  for i := 15 to 19 do
    if not Tbol[i] then
    begin
      LiE[i].Text := '';
      LiE[i].Modified := False;
    end;
  if (st < 6) and not Tbol2[st] then
  begin
    LiE[st].Text := '';
    LiE[st].Modified := False;
    Tbol[st] := False;
  end;
  if (Az < 6) and not Tbol2[Az] then
  begin
    LiE[Az].Text := '';
    LiE[Az].Modified := False;
    Tbol[Az] := False;
  end;
end;

function TForm4.{%H-}FormHelp(Command: Word; Data: PtrInt; var CallHelp: Boolean
  ): Boolean;
begin
  Form1.MaideClick(nil);
end;

procedure TForm4.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  if Elng <> '' then clng(4); // Met en place le changement de langue pour Form4
  LiC[15] := ChkG; LiC[16] := ChkX; LiC[17] := ChkY; LiC[18] := ChkSt; LiC[19] := ChkAz;
  LiE[15] := EdG; LiE[16] := EdX; LiE[17] := EdY; LiE[18] := EdSt; LiE[19] := EdAz;
  LiB[18] := UniSt; LiB[19] := UniAz;
  for i := 15 to 19 do
    Tbol[i] := False;
  for i := 15 to 17 do
    Unt[i] := 0;  // En fait en unité de longueur, mais pour obtenir directement la valeur dans Tvar[14, 0]
  Unt[18] := nunt(UniSt.Items[0]);
  Unt[19] := nunt(UniAz.Items[0]);
  EdAz.Hint := chnt(19);
  {$IF DEFINED(LINUX) OR DEFINED(DARWIN)}
  // Ajustement de la taille des Edit pour afficher entièrement les valeurs
  Width := Width + aged;
  Label2.Left := Label2.Left + aged div 2;
  Label3.Left := Label3.Left + aged;
  BtCalcul.Width := BtCalcul.Width + aged;
  for i := 15 to 19 do
  begin
    LiE[i].Width := LiE[i].Width + aged;
    if i >= 18 then LiB[i].Left := LiB[i].Left + aged;
  end;
  {$ENDIF}
  {$IFDEF DARWIN}
  // Ajustement de la taille des ComboBox pour afficher entièrement les unités
  Width := Width + agcb;
  Label3.Left := Label3.Left + agcb div 2;
  BtCalcul.Width := BtCalcul.Width + agcb;
  for i := 18 to 19 do
    LiB[i].Width := LiB[i].Width + agcb;
  {$ENDIF}
end;

end.

