{
Copyright (c) 2013 Yvon Massé
Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
}

unit Unit2;
{$MODE Delphi}

interface

uses
  SysUtils, Classes, Forms, StdCtrls, Math;

type  { TForm2 }
  TForm2 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    AEdJo: TLabel;
    AEdHo: TLabel;
    CmbAn: TComboBox;
    ChkJo: TCheckBox;
    ChkHo: TCheckBox;
    ChkFo: TCheckBox;
    ChkLg: TCheckBox;
    ChkAh: TCheckBox;
    ChkDc: TCheckBox;
    EdJo: TEdit;
    EdHo: TEdit;
    EdFo: TEdit;
    EdLg: TEdit;
    EdAh: TEdit;
    EdDc: TEdit;
    UniLg: TComboBox;
    UniAh: TComboBox;
    UniDc: TComboBox;
    BtCalcul: TButton;
    BtRaz: TButton;
    procedure CmbAnExit(Sender: TObject);
    procedure ChkJoClick(Sender: TObject);
    procedure ChkHoClick(Sender: TObject);
    procedure ChkFoClick(Sender: TObject);
    procedure ChkLgClick(Sender: TObject);
    procedure ChkAhClick(Sender: TObject);
    procedure ChkDcClick(Sender: TObject);
    procedure EdJoExit(Sender: TObject);
    procedure EdHoExit(Sender: TObject);
    procedure EdFoExit(Sender: TObject);
    procedure EdLgExit(Sender: TObject);
    procedure EdAhExit(Sender: TObject);
    procedure EdDcExit(Sender: TObject);
    procedure UniLgChange(Sender: TObject);
    procedure UniAhChange(Sender: TObject);
    procedure UniDcChange(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure BtCalculClick(Sender: TObject);
    procedure BtRazClick(Sender: TObject);
    function FormHelp({%H-}Command: Word; {%H-}Data: PtrInt; var {%H-}CallHelp: Boolean
      ): Boolean;
    procedure FormCreate(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

const
  MEph_0 = 'Extremum : nombre d’itération maxi';
  MEph_1 = 'Valeur : nombre d’itération maxi';
  MEph_2 = 'Choix du jour :';
  MEph_3 = 'Les fuseaux horaires ont été mis en place au début du XXième siècle.'#13#10'L’utilisation d’année antérieure à 1900 n’a pas de sens dans ce programme';
  MEph_4 = 'Il est nécessaire de fixer une limite supérieure,'#13#10'''Éphémérides du Soleil'' utilise arbitrairement 2149';
  MEph_5 = 'Données insuffisantes pour en calculer d’autres';
  MEph_6 = 'Déclinaison entre %s et %s %s';
  MEph_7 = 'Angle horaire entre %s et %s %s';
  MEph_8 = 'Longitude entre %s et %s %s';
  MEph_9 = 'Angle horaire effectif : %s %s';
  MEph_10 = 'Aucune date ne peut fournir ces valeurs';
  MEph_11 = 'Heure entre %s et %s %s';
  MEph_12 = 'Ou déclinaison = %s %s si le fuseau horaire'#13#10'est inférieur ou égal à %s';
  MEph_13 = 'Ou déclinaison = %s %S si le fuseau horaire'#13#10'est supérieur ou égal à %s';
  MEph_14 = 'Ou le jour précédent si le fuseau horaire'#13#10'est inférieur ou égal à %s';
  MEph_15 = 'Ou le jour suivant si le fuseau horaire'#13#10'est supérieur ou égal à %s';
  MEph_16 = 'Déclinaison effective : %s %s';
  MEph_17 = 'La déclinaison est hors de ses limites';
  MEph_18 = 'Trop de données, elles peuvent être incohérentes';
  MEph_19 = 'janv.';
  MEph_20 = 'févr.';
  MEph_21 = 'mars';
  MEph_22 = 'avr.';
  MEph_23 = 'mai';
  MEph_24 = 'juin';
  MEph_25 = 'juil.';
  MEph_26 = 'août';
  MEph_27 = 'sept.';
  MEph_28 = 'oct.';
  MEph_29 = 'nov.';
  MEph_30 = 'déc.';
{
  MEph_31 = ;
  MEph_32 = ;
  MEph_33 = ;
  MEph_34 = ;
  MEph_35 = ;
}
  mMEph = 30;

var
  Form2: TForm2;
  Ah: Integer = 10;
  dc: Integer = 11;
  MEph: Array[0..mMEph] of String =
    (MEph_0, MEph_1, MEph_2, MEph_3, MEph_4, MEph_5, MEph_6, MEph_7, MEph_8, MEph_9,
    MEph_10, MEph_11, MEph_12, MEph_13, MEph_14, MEph_15, MEph_16, MEph_17, MEph_18, MEph_19,
    MEph_20, MEph_21, MEph_22, MEph_23, MEph_24, MEph_25, MEph_26, MEph_27, MEph_28, MEph_29,
    MEph_30//, MEph_31, MEph_32, MEph_33, MEph_34, MEph_35, MEph_36, MEph_37, MEph_38, MEph_39,
    );

implementation

uses Unit1;

{$R *.lfm} { TForm2 }

function modu(ag, min, max: Real; bl: Boolean): Real;
// Si bl = True : max est inclu sinon c'est min
begin
  if bl then
  begin
    while ag > max do ag := ag - 360;
    while ag <= min do ag := ag + 360;
  end
  else
  begin
    while ag >= max do ag := ag - 360;
    while ag < min do ag := ag + 360;
  end;
  Result := ag;
end;

function adjr(var jr: Real; ag: Real): Real;
begin
  Result := ag;
  if ag <= -180 then
  begin
    jr := jr + 1;
    Result := ag + 360;
  end;
  if ag > 180 then
  begin
    jr := jr - 1;
    Result := ag - 360;
  end;
end;

procedure modul(i: Integer);
// Modulo
begin
  if i = 7 then
    Tvar[i, 0] := modu(Tvar[i, 0], 0, 360, False)
  else
    Tvar[i, 0] := modu(Tvar[i, 0], -180, 180, True);
end;

function fusho(min, max: Real; out fo: Real): Boolean;
begin
  Result := False;
  if Floor(max/15) >= min/15 then
  begin
    fo := 15*Floor(max/15);
    Result := True;
  end;
end;

function fuso(val: Real; dir: Boolean): Real;
begin
  if dir then
    Result := 15*Ceil(val/15)
  else
    Result := 15*Floor(val/15);
end;

function ahVdj(jr, fo: Real): Real;
var
  i: Integer;
  ag: Real;
begin
  ag := modu(fo + 180 + Tvar[9, 0] + modr(Ah) - 360*Frac(jr), -180, 180, False);
  repeat
    Result := 0;
    for i := 1 to 5 do
      Result := (ag - ephe(jr + Result, -fo, sAh0))/360;
    if Result < -0.5 then ag := ag + 360;
    if Result >= 0.5 then ag := ag - 360;
  until (Result >= -0.5) and (Result < 0.5);
end;

function extVju(ext: Integer; ts: Teph): Real;
const
  ni = 5;
  epsi = 1e-4;
var
  i, ie, n: Integer;
  j, se: Array[0..2] of Real;
  v0, v1, v2: Real;
begin
// initialisation
  DefaultFormatSettings.ShortDateFormat := 'd/m/yyyy';
  case ts of
    sDC:
      case ext of
        1: j[1] := StrToDate('21/06/' + Form2.CmbAn.Text);
        2: j[1] := StrToDate('21/12/' + Form2.CmbAn.Text);
      end;
    sAh0:
      case ext of
        1: j[1] := StrToDate('03/11/' + Form2.CmbAn.Text);
        2: j[1] := StrToDate('11/02/' + Form2.CmbAn.Text);
        3: j[1] := StrToDate('13/05/' + Form2.CmbAn.Text);
        4: j[1] := StrToDate('26/07/' + Form2.CmbAn.Text);
    end;
  end;
  j[0] := j[1] - 1; se[0] := ephe(j[0], 0, ts);
  se[1] := ephe(j[1], 0, ts);
  j[2] := j[1] + 1; se[2] := ephe(j[2], 0, ts);
  for n := 0 to ni do
  begin
    v0 := (j[2] - j[1])*se[0];
    v1 := (j[0] - j[2])*se[1];
    v2 := (j[1] - j[0])*se[2];
    Result := ((j[2] + j[1])*v0 + (j[0] + j[2])*v1 + (j[1] + j[0])*v2)/(v0 + v1 + v2)/2;
//    ShowMessage(IntToStr(n) + #13#10
//              + DateTimeToStr(j[0]) + ' / ' + FloatToStr(Result - j[0]) + #13#10
//              + DateTimeToStr(j[1]) + ' / ' + FloatToStr(Result - j[1]) + #13#10
//              + DateTimeToStr(j[2]) + ' / ' + FloatToStr(Result - j[2]) + #13#10
//              + DateTimeToStr(Result) + ' / ' + FloatToStr(ephe(Result, 0, ts)));
    if SameValue(Result, j[0], epsi) or SameValue(Result, j[1], epsi) or SameValue(Result, j[2], epsi) then break;
    ie := 0;
    for i := 1 to 2 do
      if Abs(Result - j[ie]) < Abs(Result - j[i]) then ie := i;
    j[ie] := Result; se[ie] := ephe(Result, 0, ts);
  end;
  if n = ni then MessDlgPos(MEph[0], mtError, Form2.Left + xms, Form2.Top + yms);
  DefaultFormatSettings.ShortDateFormat := MTri[28] + '/yyyy';
end;

function veVjr(ve, fo: Real; prt: Integer; ts: Teph): Real;
const
  ni = 20;
  epsi = 1e-5;
var
  ie, n, ba: Integer;
  j, se: Array[0..1] of Real;
  ji: Real;
begin
  DefaultFormatSettings.ShortDateFormat := 'd/m/yyyy';
  case ts of
    sDc:
      case prt of
        1: ji := StrToDate('20/03/' + Form2.CmbAn.Text);
        2: ji := StrToDate('23/09/' + Form2.CmbAn.Text);
      end;
    sAh0:
      case prt of
        1: ji := StrToDate('26/03/' + Form2.CmbAn.Text);
        2: ji := StrToDate('20/06/' + Form2.CmbAn.Text);
        3: ji := StrToDate('16/09/' + Form2.CmbAn.Text);
        4: ji := StrToDate('22/12/' + Form2.CmbAn.Text);
      end;
  end;
  ba := 0;
  repeat
    // Initialisation pour entrer dans la boucle d'itération
    j[0] := ji;
    se[0] := ephe(j[0], 0, ts) - ve;
    j[1] := j[0] + 1; se[1] := ephe(j[1], 0, ts) - ve;
    // Boucle d'itération
    for n := 0 to ni do
    begin
      Result := (j[0]*se[1] - j[1]*se[0])/(se[1] - se[0]);
//      ShowMessage(IntToStr(n) + #13#10
//                + DateTimeToStr(j[0]) + ' / ' + FloatToStr(Result - j[0]) + #13#10
//                + DateTimeToStr(j[1]) + ' / ' + FloatToStr(Result - j[1]) + #13#10
//                + DateTimeToStr(Result) + ' / ' + FloatToStr(ephe(Result, 0, ts)));
      if SameValue(Result, j[0], epsi) or SameValue(Result, j[1], epsi) then break;
      ie := 0;
      if Abs(Result - j[1]) > Abs(Result - j[0]) then ie := 1;
      j[ie] := Result; se[ie] := ephe(Result, 0, ts) - ve;
    end;
    if n = ni then MessDlgPos(MEph[1], mtError, Form2.Left + xms, Form2.Top + yms);
    Result := Result + fo/360; // Prise en compte du fuseau horaire pour obtenir la date de l'observateur
    if ba = 0 then
      if FormatDateTime('yyyy', Result) <> Form2.CmbAn.Text then
        case ts of
          sDC: ji := ji + 365.25;
          sAh0: ji := ji - 365.25;
        end
      else
       Inc(ba);
    Inc(ba);
  until ba = 2;
  DefaultFormatSettings.ShortDateFormat := MTri[28] + '/yyyy';
end;

function selVjr(ve, fo: Real; ts: Teph; out vs: Real): Boolean;
var
  jc: Array[1..4] of Real;
  tjc: Array[1..4] of String;
  i, nc: Integer;
begin
  Result := (ve <= ephe(extVju(1, ts), 0, ts)) and (ve >= ephe(extVju(2, ts), 0, ts));
  if Result then
  begin
    nc := 2;
    case ts of
      sDc: begin
        jc[1] := veVjr(ve, fo, 1, sDc);
        jc[2] := veVjr(ve, fo, 2, sDc);
        if jc[1] > jc[2] then
        begin
          ve := jc[1]; jc[1] := jc[2]; jc[2] := ve;
        end;
      end;
      sAh0: begin
        if ve < 0 then
          if ve < ephe(extVju(4, sAh0), 0, sAh0) then
          begin
            jc[1] := veVjr(ve, fo, 1, sAh0);
            jc[2] := veVjr(ve, fo, 4, sAh0);
            if jc[1] > jc[2] then
            begin
              ve := jc[1]; jc[1] := jc[2]; jc[2] := ve;
            end;
          end
          else
            nc := 4
        else
          if ve > ephe(extVju(3, sAh0), 0, sAh0) then
          begin
            jc[1] := veVjr(ve, fo, 3, sAh0);
            jc[2] := veVjr(ve, fo, 4, sAh0);
          end
          else
            nc := 4;
        if nc = 4 then
        begin
          jc[1] := veVjr(ve, fo, 1, sAh0);
          jc[2] := veVjr(ve, fo, 2, sAh0);
          jc[3] := veVjr(ve, fo, 3, sAh0);
          jc[4] := veVjr(ve, fo, 4, sAh0);
          if jc[1] > jc[4] then
          begin
            ve := jc[4]; jc[4] := jc[3]; jc[3] := jc[2]; jc[2] := jc[1]; jc[1] := ve;
          end;
        end;
      end;
    end;
    for i := 1 to nc do
      tjc[i] := chrt(jc[i], 6, 0);
    i := SelBoxPos(MTri[13], MEph[2], tjc, nc, Form2.Left + xms, Form2.Top + yms);
    vs := jc[i];
  end;
end;

procedure TForm2.CmbAnExit(Sender: TObject);
var
  an: Integer;
begin
  try
    an := StrToInt(CmbAn.Text);
  except
    an := StrToInt(FormatDateTime('yyyy', Date));
  end;
  CmbAn.Text := FormatDateTime('yyyy', StrToDate('6/6/' + IntToStr(an)));
  an := StrToInt(CmbAn.Text);
  if an < 1900 then
  begin
    MessDlgPos(MEph[3], mtError, Left + xms, Top + yms);
    CmbAn.Text := FormatDateTime('yyyy', Date);
  end;
  if an > 2149 then
  begin
    MessDlgPos(MEph[4], mtError, Left + xms, Top + yms);
    CmbAn.Text := FormatDateTime('yyyy', Date);
  end;
end;

procedure TForm2.ChkJoClick(Sender: TObject);
begin
  ChkClick(6);
end;

procedure TForm2.ChkHoClick(Sender: TObject);
begin
  ChkClick(7);
end;

procedure TForm2.ChkFoClick(Sender: TObject);
begin
  ChkClick(8);
end;

procedure TForm2.ChkLgClick(Sender: TObject);
begin
  ChkClick(9);
end;

procedure TForm2.ChkAhClick(Sender: TObject);
begin
  ChkClick(10);
end;

procedure TForm2.ChkDcClick(Sender: TObject);
begin
  ChkClick(11);
end;

procedure TForm2.EdJoExit(Sender: TObject);
begin
  EdExit(6);
end;

procedure TForm2.EdHoExit(Sender: TObject);
begin
  EdExit(7);
end;

procedure TForm2.EdFoExit(Sender: TObject);
begin
  EdExit(8);
end;

procedure TForm2.EdLgExit(Sender: TObject);
begin
  EdExit(9);
end;

procedure TForm2.EdAhExit(Sender: TObject);
begin
  EdExit(10);
end;

procedure TForm2.EdDcExit(Sender: TObject);
begin
  EdExit(11);
end;

procedure TForm2.UniLgChange(Sender: TObject);
begin
  UniChange(9);
end;

procedure TForm2.UniAhChange(Sender: TObject);
begin
  UniChange(10);
end;

procedure TForm2.UniDcChange(Sender: TObject);
begin
  UniChange(11);
end;

procedure TForm2.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState
  );
// Outil de mise au point pour afficher les valeurs calculées en pleine définition
begin
  if (Key = Ord('Y')) and (ssCtrl in Shift) then
  begin
    quits();        // Pour quitter un éventuel champ de saisie
    MessDlgPos(MTri[15]
        + #13#10'6 : ' + BoolToStr(Tbol[6], True)+ ', ' + FloatToStr(Tvar[6, 0])
        + #13#10'7 : ' + BoolToStr(Tbol[7], True)+ ', ' + FloatToStr(Tvar[7, 0])
        + #13#10'8 : ' + BoolToStr(Tbol[8], True)+ ', ' + FloatToStr(Tvar[8, 0])
        + #13#10'9 : ' + BoolToStr(Tbol[9], True)+ ', ' + FloatToStr(Tvar[9, 0])
        + #13#10'10 : ' + BoolToStr(Tbol[10], True)+ ', ' + FloatToStr(Tvar[10, 0])
        + #13#10'11 : ' + BoolToStr(Tbol[11], True)+ ', ' + FloatToStr(Tvar[11, 0]),
        mtInformation, Left + Width, Top);
  end;
end;

procedure TForm2.BtCalculClick(Sender: TObject);
var
  i, p2, cf: Integer;
  jr, hr, fo, ag, dj: Real;
  vmin, vmax: Real;
begin
  quits();            // Pour quitter un éventuel champ de saisie
  if Tbol[6] then     // Prise en compte de l'année dans la date
    Tvar[6, 0] := StrToDate(FormatDateTime(MTri[28], Tvar[6, 0]) + '/' + Form2.CmbAn.Text);
  p2 := 1; cf := 0;
  for i := 6 to 9 do  // Calcul de la configuration
  begin
    if Tbol[i] then cf := cf + p2;
    p2 := 2*p2;
  end;
  if (Ah < 6) then
    if Tbol2[Ah] then cf := cf + p2 else
  else
    if Tbol[Ah] then cf := cf + p2;
  p2 := 2*p2;
  if (dc < 6) then
    if Tbol2[dc] then cf := cf + p2 else
  else
    if Tbol[dc] then cf := cf + p2 else;
  case cf of    // Traitement des configurations avec manque de données
    0, 2, 4, 6, 8, 10, 12, 16, 18, 20, 24:
      MessDlgPos(MEph[5], mtError, Left + xms, Top + yms);
    else begin
      for i := 6 to 11 do                // Décoche la case s'il n'y a pas de valeur saisie
        if LiC[i].Checked and not Tbol[i] then LiC[i].Checked := False;
      if (Ah < 6) and LiC2[Ah].Checked and not Tbol2[Ah] then LiC2[Ah].Checked := False;
      if (dc < 6) and LiC2[dc].Checked and not Tbol2[dc] then LiC2[dc].Checked := False;
      case cf of    // Traitement des autres configurations
        1, 3, 5, 9, 11, 13, 17, 19, 21: begin
          case cf of
            1, 9, 17: begin
              vmin := ephe(Tvar[6, 0], -180, sDc);
              vmax := ephe(Tvar[6, 0], 540, sDc);
              Tvar[dc, 0] := ephe(Tvar[6, 0], 180, sDc);
            end;
            3, 11, 19: begin
              vmin := ephe(Tvar[6, 0], Tvar[7, 0] - 180, sDc);
              vmax := ephe(Tvar[6, 0], Tvar[7, 0] + 180, sDc);
              Tvar[dc, 0] := ephe(Tvar[6, 0], Tvar[7, 0], sDc);
            end;
            5, 13, 21: begin
              vmin := ephe(Tvar[6, 0], -Tvar[8, 0], sDc);
              vmax := ephe(Tvar[6, 0], 360 - Tvar[8, 0], sDc);
              Tvar[dc, 0] := ephe(Tvar[6, 0], 180 - Tvar[8, 0], sDc);
            end;
          end;
          afrt(dc);
          if vmin > vmax then
          begin
            ag := vmin; vmin := vmax; vmax := ag;
          end;
          MessDlgPos(Format(MEph[6], [chrt(vmin, dc, prc), chrt(vmax, dc, prc), MTri[Unt[dc] + dLun]]), mtInformation, Left + xms, Top + yms);
        end;
        7, 15, 23: begin
          case cf of
            15: begin
              Tvar[Ah, 0] := Tvar[7, 0] - Tvar[8, 0] - 180 - Tvar[9, 0] + ephe(Tvar[6, 0], Tvar[7, 0] - Tvar[8, 0], sAh0);
              modul(Ah); afrt(Ah);
            end;
            23: begin
              Tvar[9, 0] := Tvar[7, 0] - Tvar[8, 0] - 180 - modr(Ah) + ephe(Tvar[6, 0], Tvar[7, 0] - Tvar[8, 0], sAh0);
              modul(9); afrt(9);
            end;
          end;
          Tvar[dc, 0] := ephe(Tvar[6, 0], Tvar[7, 0] - Tvar[8, 0], sDc); afrt(dc);
        end;
        14, 22, 26, 28, 30: begin
          vmin := ephe(extVju(2, sAh0), 0, sAh0);
          vmax := ephe(extVju(1, sAh0), 0, sAh0);
          case cf of
            14: begin
              Tvar[Ah, 0] := Tvar[7, 0] - Tvar[8, 0] - 180 - Tvar[9, 0];
              modul(Ah); afrt(Ah);
              MessDlgPos(Format(MEph[7], [chrt(modr(Ah) + vmin, Ah, prc), chrt(modr(Ah) + vmax, Ah, prc), MTri[Unt[Ah] + dLun]]),
                         mtInformation, Left + xms, Top + yms);
            end;
            22: begin
              Tvar[9, 0] := Tvar[7, 0] - Tvar[8, 0] - 180 - modr(Ah);
              modul(9); afrt(9);
              MessDlgPos(Format(MEph[8], [chrt(Tvar[9, 0] + vmin, 9, prc), chrt(Tvar[9, 0] + vmax, 9, prc), MTri[Unt[9] + dLun]]),
                         mtInformation, Left + xms, Top + yms);
            end;
            26, 30: begin
              fo := Tvar[8, 0];
              ag := modu(Tvar[7, 0] - 180 - Tvar[9, 0] - modr(Ah), -180, 180, True);
              if (cf = 26) and not fusho(ag + vmin, ag + vmax, fo) then
                  fo := ag + vmax + 1; // Pour avoir False en sortie de selVjr
              if selVjr(fo - ag, fo, sAh0, jr) then
              begin
                adjr(jr, Tvar[7, 0] - 360*Frac(jr));
                Tvar[6, 0] := Floor(jr); afrt(6);
                if cf = 26 then
                begin
                  Tvar[8, 0] := fo; afrt(8);
                end;
                Tvar[dc, 0] := ephe(Tvar[6, 0], Tvar[7, 0] - fo, sDc); afrt(dc);
                ag := modu(Tvar[7, 0] - fo - 180 - Tvar[9, 0] + ephe(Tvar[6, 0], Tvar[7, 0] - fo, sAh0), -180, 180, True);
                MessDlgPos(Format(MEph[9], [chrt(ag, Ah, prc), MTri[Unt[Ah] + dLun]]), mtInformation, Left + xms, Top + yms);
              end
              else
                MessDlgPos(MEph[10], mtError, Left + xms, Top + yms);
            end;
            28: begin
              Tvar[7, 0] := Tvar[8, 0] + 180 + Tvar[9, 0] + modr(Ah);
              modul(7); afrt(7);
              vmax := modu(Tvar[7, 0] - vmax, 0, 360, False);
              vmin := modu(Tvar[7, 0] - vmin, 0, 360, False);
              MessDlgPos(Format(MEph[11], [chrt(vmax, 7, prc), chrt(vmin, 7, prc), MTri[Unt[7] + dLun]]), mtInformation, Left + xms, Top + yms);
            end;
          end;
        end;
        25, 27, 29: begin
          if cf = 27 then
          begin
            dj := ahVdj(Tvar[6, 0] + Tvar[7, 0]/360, 0);
            fo := 15*Round(-24*dj);
            Tvar[8, 0] := fo; afrt(8);
            dj := Tvar[7, 0]/360 - 0.5;
          end
          else
          begin
            if cf = 29 then fo := Tvar[8, 0] else fo := 0;
            dj := ahVdj(Tvar[6, 0] + 0.5, fo);
          end;
          Tvar[dc, 0] := ephe(Tvar[6, 0] + 0.5 + dj, -fo, sDc); afrt(dc);
          case cf of
            25:
              if dj < 0 then
                MessDlgPos(Format(MEph[12], [chrt(ephe(Tvar[6, 0] + 1.5 + dj, 0, sDc), dc, prc),
                                             MTri[Unt[dc] + dLun], chrt(fuso(-360*(0.5 + dj), False), 8, prc)]),
                           mtInformation, Left + xms, Top + yms)
              else
                MessDlgPos(Format(MEph[13], [chrt(ephe(Tvar[6, 0] - 0.5 + dj, 0, sDc), dc, prc),
                                             MTri[Unt[dc] + dLun], chrt(fuso(360*(0.5 - dj), True), 8, prc)]),
                           mtInformation, Left + xms, Top + yms);
            27: begin
              ag := modu(Tvar[7, 0] - fo - 180 - Tvar[9, 0] + ephe(Tvar[6, 0], Tvar[7, 0] - fo, sAh0), -180, 180, True);
              MessDlgPos(Format(MEph[9], [chrt(ag, Ah, prc), MTri[Unt[Ah] + dLun]]), mtInformation, Left + xms, Top + yms);
            end;
            29: begin
              Tvar[7, 0] := 360*(0.5 + dj); afrt(7);
            end;
          end;
        end;
        32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54: begin
          if (cf = 36) or (cf = 38) or (cf = 44) or (cf = 46) or (cf = 52) or (cf = 54) then
            fo := Tvar[8, 0] else fo := 0;
          if selVjr(modr(dc), fo, sDc, jr) then
          begin
            case cf of
              34, 42, 50: begin    // Calcul de fo et mise à jour de jr
                fo := 15*Round((Tvar[7, 0] - 360*Frac(jr))/15);
                fo := adjr(jr, fo);
                Tvar[8, 0] := fo; afrt(8);
                jr := Floor(jr) + Tvar[7, 0]/360;
              end;
              38, 46, 54: begin    // Mise à jour de jr
                adjr(jr, Tvar[7, 0] - 360*Frac(jr));
                jr := Floor(jr) + Tvar[7, 0]/360;
              end;
            end;
            Tvar[6, 0] := Floor(jr); afrt(6);
            hr := 360*Frac(jr);
            if (cf = 36) or (cf = 44) or (cf = 52) then
            begin
              Tvar[7, 0] := hr; afrt(7);
            end;
            if (cf = 40) or (cf = 42) or (cf = 44) or (cf = 46) then
            begin
              Tvar[Ah, 0] := hr - fo - 180 - Tvar[9, 0] + ephe(jr, -fo, sAh0);
              modul(Ah); afrt(Ah);
            end;
            if (cf = 48) or (cf = 50) or (cf = 52) or (cf = 54) then
            begin
              Tvar[9, 0] := hr - fo - 180 - modr(Ah) + ephe(jr, -fo, sAh0);
              modul(9); afrt(9);
            end;
            if (cf = 32) or (cf = 40) or (cf = 48) then
              if hr < 180 then
                MessDlgPos(Format(MEph[14], [chrt(fuso(-hr, False), 8, prc)]),
                           mtInformation, Left + xms, Top + yms)
              else
                MessDlgPos(Format(MEph[15], [chrt(fuso(360 - hr, True), 8, prc)]),
                           mtInformation, Left + xms, Top + yms);
            if (cf = 34) or (cf = 38) or (cf = 42) or (cf = 46) or (cf = 50) or (cf = 54) then
              MessDlgPos(Format(MEph[16], [chrt(ephe(jr, -fo, sDc), dc, prc), MTri[Unt[dc] + dLun]]),
                         mtInformation, Left + xms, Top + yms);
          end
          else
            MessDlgPos(MEph[17], mtError, Left + xms, Top + yms);
        end;
        56, 58, 60: begin
          if cf = 60 then fo := Tvar[8, 0] else fo := 0;
          if selVjr(modr(dc), fo, sDc, jr) then
          begin
            dj := ahVdj(jr, fo);
            if cf = 58 then
            begin
              fo := 15*Round((Tvar[7, 0] - 360*Frac(jr + dj))/15);
              fo := adjr(jr, fo);
              Tvar[6, 0] := Floor(jr + dj); afrt(6);
              Tvar[8, 0] := fo; afrt(8);
              ag := modu(Tvar[7, 0] - fo - 180 - Tvar[9, 0] + ephe(Tvar[6, 0], Tvar[7, 0] - fo, sAh0), -180, 180, True);
              MessDlgPos(Format(MEph[9], [chrt(ag, Ah, prc), MTri[Unt[Ah] + dLun]]), mtInformation, Left + xms, Top + yms);
              hr := Tvar[7, 0]
            end
            else
            begin
              Tvar[6, 0] := Floor(jr + dj); afrt(6);
              hr := 360*Frac(jr + dj);
            end;
            case cf of
              56:
                if hr < 180 then
                  MessDlgPos(Format(MEph[14], [chrt(fuso(-hr, False), 8, prc)]), mtInformation, Left + xms, Top + yms)
                else
                  MessDlgPos(Format(MEph[15], [chrt(fuso(360 - hr, True), 8, prc)]), mtInformation, Left + xms, Top + yms);
              60: begin
                Tvar[7, 0] := hr; afrt(7);
              end;
            end;
            MessDlgPos(Format(MEph[16], [chrt(ephe(Tvar[6, 0], hr - fo, sDc), dc, prc), MTri[Unt[dc] + dLun]]),
                       mtInformation, Left + xms, Top + yms);
          end
          else
            MessDlgPos(MEph[17], mtError, Left + xms, Top + yms);
        end;
        else MessDlgPos(MEph[18], mtError, Left + xms, Top + yms);
      end;
    end;
  end;
end;

procedure TForm2.BtRazClick(Sender: TObject);
var
  i: Integer;
begin
  quits();            // Pour quitter un éventuel champ de saisie
  for i := 6 to 11 do
    if not Tbol[i] then
    begin
      LiE[i].Text := '';
      LiE[i].Modified := False;
      case i of
        6: AEdJo.Caption := '';
        7: AEdHo.Caption := '';
      end;
    end;
  if (Ah < 6) and not Tbol2[Ah] then
  begin
    LiE[Ah].Text := '';
    LiE[Ah].Modified := False;
    Tbol[Ah] := False;
  end;
  if (dc < 6) and not Tbol2[dc] then
  begin
    LiE[dc].Text := '';
    LiE[dc].Modified := False;
    Tbol[dc] := False;
  end;
end;

function TForm2.{%H-}FormHelp(Command: Word; Data: PtrInt; var CallHelp: Boolean
  ): Boolean;
begin
  Form1.MaideClick(nil);
end;

procedure TForm2.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  if Elng <> '' then clng(2); // Met en place le changement de langue pour Unit2 et Form2
  DefaultFormatSettings.DateSeparator := '/';
  DefaultFormatSettings.TimeSeparator := ':';
  DefaultFormatSettings.ShortDateFormat := MTri[28] + '/yyyy';
  DefaultFormatSettings.ShortMonthNames[1] := MEph[19];
  DefaultFormatSettings.ShortMonthNames[2] := MEph[20];
  DefaultFormatSettings.ShortMonthNames[3] := MEph[21];
  DefaultFormatSettings.ShortMonthNames[4] := MEph[22];
  DefaultFormatSettings.ShortMonthNames[5] := MEph[23];
  DefaultFormatSettings.ShortMonthNames[6] := MEph[24];
  DefaultFormatSettings.ShortMonthNames[7] := MEph[25];
  DefaultFormatSettings.ShortMonthNames[8] := MEph[26];
  DefaultFormatSettings.ShortMonthNames[9] := MEph[27];
  DefaultFormatSettings.ShortMonthNames[10] := MEph[28];
  DefaultFormatSettings.ShortMonthNames[11] := MEph[29];
  DefaultFormatSettings.ShortMonthNames[12] := MEph[30];
  CmbAn.Text := FormatDateTime('yyyy', Date);
  LiC[6] := ChkJo; LiC[7] := ChkHo; LiC[8] := ChkFo; LiC[9] := ChkLg; LiC[10] := ChkAh; LiC[11] := ChkDc;
  LiE[6] := EdJo; LiE[7] := EdHo; LiE[8] := EdFo; LiE[9] := EdLg; LiE[10] := EdAh; LiE[11] := EdDc;
                                                  LiB[9] := UniLg; LiB[10] := UniAh; LiB[11] := UniDc;
  for i := 6 to 11 do Tbol[i] := False;
  Unt[6] := fLun - dLun + 1;
  Unt[7] := 9; // h
  Unt[8] := 9; // h
  for i := 9 to 11 do
  begin
    Unt[i] := nunt(LiB[i].Items[0]);
    LiE[i].Hint := chnt(i);
  end;
  {$IF DEFINED(LINUX) OR DEFINED(DARWIN)}
  // Ajustement de la taille des Edit pour afficher entièrement les valeurs
  Width := Width + aged;
  Label3.Left := Label3.Left + aged div 2;
  Label4.Left := Label4.Left + aged;
  CmbAn.Width := CmbAn.Width + aged;
  AEdJo.Left := AEdJo.Left + aged;
  AEdHo.Left := AEdHo.Left + aged;
  BtCalcul.Width := BtCalcul.Width + aged;
  for i := 6 to 11 do
  begin
    LiE[i].Width := LiE[i].Width + aged;
    if i >= 9 then LiB[i].Left := LiB[i].Left + aged;
  end;
  {$ENDIF}
  {$IFDEF DARWIN}
  // Ajustement de la taille des ComboBox pour afficher entièrement les unités
  Width := Width + agcb;
  Label4.Left := Label4.Left + agcb div 2;
  BtCalcul.Width := BtCalcul.Width + agcb;
  for i := 9 to 11 do
    LiB[i].Width := LiB[i].Width + agcb;
  {$ENDIF}
end;

end.

